<?php
require 'session-master.php';
require 'functions.php';
require './PDFvendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

/* =====================================================
   HARD SAFETY — NO OUTPUT
===================================================== */
ini_set('display_errors', 0);
error_reporting(0);

while (ob_get_level()) {
    ob_end_clean();
}
ob_start();

/* =====================================================
   SESSION CHECK
===================================================== */
if (!isset($_SESSION['company_id'])) {
    exit;
}

$company_id = (int) $_SESSION['company_id'];

/* =====================================================
   DATE FILTER
===================================================== */
$start_date = $_GET['init_date'] ?? null;
$end_date   = $_GET['final_date'] ?? null;

$where = "WHERE company_id = ?";
$params = [$company_id];

if ($start_date && $end_date) {
    $where .= " AND DATE(voucher_date) BETWEEN ? AND ?";
    $params[] = $start_date;
    $params[] = $end_date;
}

$order = " ORDER BY voucher_date DESC";

/* =====================================================
   DB CONNECTION
===================================================== */
$mysqli = new mysqli(
    DATABASE_HOST,
    DATABASE_USER,
    DATABASE_PASS,
    DATABASE_NAME
);

if ($mysqli->connect_error) {
    exit;
}

/* =====================================================
   FETCH COMPANY
===================================================== */
$stmt = $mysqli->prepare("
    SELECT company_name, company_address, company_state, currency
    FROM company
    WHERE id = ?
    LIMIT 1
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$company = $stmt->get_result()->fetch_assoc();

/* =====================================================
   FETCH EXPENSES
===================================================== */
$sql = "
    SELECT * FROM vouchers
    $where
    $order
";

$stmt = $mysqli->prepare($sql);
$stmt->bind_param(str_repeat("s", count($params)), ...$params);
$stmt->execute();
$result = $stmt->get_result();

$mysqli->close();

/* =====================================================
   BUILD HTML (VALID HTML ONLY)
===================================================== */
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Transactions Report</title>

<style>
body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }

h3 { text-align:center; margin:6px 0; }

table {
    width:100%;
    border-collapse:collapse;
}

th, td {
    border:1px solid #000;
    padding:5px;
    font-size:11px;
}

th {
    background:#eee;
}
</style>
</head>

<body>

<h3><?= htmlspecialchars($company['company_name']) ?></h3>
<h3>
Vouchers List
<?php if ($start_date && $end_date): ?>
<span style="font-size:11px;">
(<?= htmlspecialchars($start_date) ?> - <?= htmlspecialchars($end_date) ?>)
</span>
<?php endif; ?>
</h3>

<table>
<thead>
<tr>
    <th width="7%">S/N</th>
    <th width="10%">ID</th>
    <th width="12%">DATE</th>
    <th width="25%">TITLE</th>
    <th width="12%">MODE</th>
    <th width="15%">REQUESTED BY</th>
    <th width="20%">AMOUNT (<?= htmlspecialchars($company['currency']) ?>)</th>
</tr>
</thead>
<tbody>

<?php
$i = 1;
while ($row = $result->fetch_assoc()):
?>
<tr>
    <td><?= $i++ ?></td>
    <td><?= htmlspecialchars($row['voucher_id']) ?></td>
    <td><?= htmlspecialchars($row['voucher_date']) ?></td>
    <td><?= htmlspecialchars($row['short_title']) ?></td>
    <td><?= htmlspecialchars($row['payment_mode']) ?></td>
    <td><?= htmlspecialchars($row['requested_by']) ?></td>
    <td><?= number_format($row['total'], 2) ?></td>
</tr>
<?php endwhile; ?>

</tbody>
</table>

</body>
</html>
<?php
$html = ob_get_clean();

/* =====================================================
   DOMPDF — SAFE OUTPUT
===================================================== */
$options = new Options();
$options->set('defaultFont', 'DejaVu Sans');
$options->set('isRemoteEnabled', false);

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html, 'UTF-8');
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

$date = date('dmY'); 

$dompdf->stream(
    "Vouchers-$date.pdf",
    ['Attachment' => true]
);

exit;
