<?php
require 'session-master.php';
require 'functions.php';
require './PDFvendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

/* =====================================================
   HARD SAFETY — NO OUTPUT
===================================================== */
ini_set('display_errors', 0);
error_reporting(0);

while (ob_get_level()) {
    ob_end_clean();
}
ob_start();

/* =====================================================
   SESSION CHECK
===================================================== */
if (!isset($_SESSION['company_id'])) {
    exit;
}

$company_id = (int) $_SESSION['company_id'];

/* =====================================================
   DATE FILTER
===================================================== */
$start_date = $_GET['init_date'] ?? null;
$end_date   = $_GET['final_date'] ?? null;

$where = "WHERE company_id = ?";
$params = [$company_id];

if ($start_date && $end_date) {
    $where .= " AND DATE(expense_date) BETWEEN ? AND ?";
    $params[] = $start_date;
    $params[] = $end_date;
}

$order = " ORDER BY expense_date DESC";

/* =====================================================
   DB CONNECTION
===================================================== */
$mysqli = new mysqli(
    DATABASE_HOST,
    DATABASE_USER,
    DATABASE_PASS,
    DATABASE_NAME
);

if ($mysqli->connect_error) {
    exit;
}

/* =====================================================
   FETCH COMPANY
===================================================== */
$stmt = $mysqli->prepare("
    SELECT company_name, company_address, company_state, currency
    FROM company
    WHERE id = ?
    LIMIT 1
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$company = $stmt->get_result()->fetch_assoc();

/* =====================================================
   FETCH EXPENSES
===================================================== */
$sql = "
    SELECT expense_id, expense_date, transaction_type,
           expense_desc, authorised_by, expense_amount
    FROM expenses
    $where
    $order
";

$stmt = $mysqli->prepare($sql);
$stmt->bind_param(str_repeat("s", count($params)), ...$params);
$stmt->execute();
$result = $stmt->get_result();

$mysqli->close();

/* =====================================================
   BUILD HTML (VALID HTML ONLY)
===================================================== */
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Transactions Report</title>

<style>
body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }

h3 { text-align:center; margin:6px 0; }

table {
    width:100%;
    border-collapse:collapse;
}

th, td {
    border:1px solid #000;
    padding:5px;
    font-size:11px;
}

th {
    background:#eee;
}
</style>
</head>

<body>

<h3><?= htmlspecialchars($company['company_name']) ?></h3>
<h3>
Transactions List
<?php if ($start_date && $end_date): ?>
<span style="font-size:11px;">
(<?= htmlspecialchars($start_date) ?> - <?= htmlspecialchars($end_date) ?>)
</span>
<?php endif; ?>
</h3>

<table>
<thead>
<tr>
    <th width="5%">S/N</th>
    <th width="10%">ID</th>
    <th width="12%">DATE</th>
    <th width="12%">TYPE</th>
    <th width="31%">NARRATION</th>
    <th width="15%">AUTHORISED BY</th>
    <th width="15%">AMOUNT (<?= htmlspecialchars($company['currency']) ?>)</th>
</tr>
</thead>
<tbody>

<?php
$i = 1;
while ($row = $result->fetch_assoc()):
?>
<tr>
    <td><?= $i++ ?></td>
    <td><?= htmlspecialchars($row['expense_id']) ?></td>
    <td><?= htmlspecialchars($row['expense_date']) ?></td>
    <td><?= strtoupper(htmlspecialchars($row['transaction_type'])) ?></td>
    <td><?= htmlspecialchars($row['expense_desc']) ?></td>
    <td><?= htmlspecialchars($row['authorised_by']) ?></td>
    <td><?= number_format($row['expense_amount'], 2) ?></td>
</tr>
<?php endwhile; ?>

</tbody>
</table>

</body>
</html>
<?php
$html = ob_get_clean();

/* =====================================================
   DOMPDF — SAFE OUTPUT
===================================================== */
$options = new Options();
$options->set('defaultFont', 'DejaVu Sans');
$options->set('isRemoteEnabled', false);

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html, 'UTF-8');
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

$date = date('dmY'); // daymonthyear e.g. 01122026

$dompdf->stream(
    "Transactions-$date.pdf",
    ['Attachment' => true]
);

exit;
