

<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <!-- Favicon -->
    <link rel="apple-touch-icon" sizes="180x180" href="app-assets/favicon/inv.png">
    <link rel="icon" type="image/png" sizes="32x32" href="app-assets/favicon/inv.png">
    <link rel="icon" type="image/png" sizes="16x16" href="app-assets/favicon/inv.png">
    <link rel="manifest" href="app-assets/favicon/inv.png">
    <link rel="mask-icon" href="app-assets/favicon/inv.png" color="#0010f7">

    <title>Login System with Forgot Password</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!-- Style CSS -->
<style>
@import url('https://fonts.googleapis.com/css?family=Montserrat:400,500,600,700|Poppins:400,500&display=swap');

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: 'Poppins', sans-serif;
}

/* BODY BACKGROUND */
body {
    background: #ffffff;
}

/* Page wrapper */
.bg-img {
    position: relative;
    width: 100%;
    height: 100vh;
    background: #ffffff;

    display: flex;
    justify-content: center;
    align-items: center;

    overflow: hidden;
    text-align: center;
}


/*
.bg-img::after {
    content: '';
    position: absolute;
    inset: 0;
    background: rgba(0, 0, 0, 0.7);
    z-index: 1;
}
*/

/* Card */
.content {
    position: relative;
    z-index: 2;
    background: #ffffff;
    border-radius: 10px;
    padding: 50px 40px;
    text-align: center;
    box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
    max-width: 400px;
    width: 100%;
}

/* Header */
.content header {
    color: #2c3e50;
    font-size: 32px;
    font-weight: 600;
    margin-bottom: 25px;
    font-family: 'Montserrat', sans-serif;
}

/* Fields */
.field {
    position: relative;
    margin-top: 20px;
}

.field input {
    width: 100%;
    padding: 12px 45px 12px 15px;
    font-size: 15px;
    border: 1px solid #ddd;
    border-radius: 6px;
    outline: none;
    background: #fff;
    color: #333;
}

/* Show password */
.field span {
    position: absolute;
    top: 12px;
    right: 15px;
    color: #888;
    font-size: 13px;
    cursor: pointer;
}

/* Submit button */
.field input[type="submit"] {
    background: #040461ff;
    color: #fff;
    font-weight: 600;
    cursor: pointer;
    transition: background 0.3s ease;
    padding: 12px;
    border: none;
}

.field input[type="submit"]:hover {
    background: #029c4a;
}

/* Forgot password */
.pass {
    text-align: left;
    margin: 10px 0;
}

.pass a {
    color: #040461ff;
    font-size: 14px;
    text-decoration: none;
}

.pass a:hover {
    text-decoration: underline;
}

/* Signup text */
.signup {
    color: #555;
    font-size: 14px;
    margin-top: 20px;
}

.signup a {
    color: #040461ff;
    text-decoration: none;
}

.signup a:hover {
    text-decoration: underline;
}

/* Footer */
.page-footer {
    position: fixed;
    bottom: 15px;
    width: 100%;
    text-align: center;
    font-size: 13px;
    color: #777;
}

.page-footer span {
    font-weight: 500;
    color: #040461ff;
}

</style>

</head>

<body>
    <div class="bg-img">
        <div class="content">
            <div class="login-form">
               <header><img src="images/icon/invoice360-logo.png" alt="invoice360-logo" width="300px"></header>
                <form action="endpoint/login.php" method="POST">
                    <div class="field">
                        <input type="email" name="email" required placeholder="Email address">
                    </div>
                    <div class="field">
                        <input type="password" class="pass-key" name="password" required placeholder="Password">
                        <span class="show">SHOW</span>
                    </div>
                    <div class="pass">
                        <a href="" onclick="showResetPassword(event)">Forgot Password?</a>
                    </div>
                    <div class="field">
                        <input type="submit" value="LOGIN">
                    </div>
                    <div class="signup">Don't have an account?
                        <a href="" onclick="showRegistration(event)"><b>Signup Now</b></a>
                    </div>
                </form>
            </div>

            <div class="registration-form"  style="display: none;">
                <header><img src="images/icon/invoice360-logo.png" alt="invoice360-logo" width="300px"></header>
                <form action="endpoint/register.php" method="POST">
                    <div class="field">
                        <input type="text" name="company_name" id="registername" required placeholder="Company Name">
                    </div>
                    <div class="field">
                        <input type="text" name="name" id="registername" required placeholder="Full Name">
                    </div>
                    <div class="field">
                        <input type="email" name="email" id="registerUsername" required placeholder="Email Address">
                    </div>
                    <div class="field">
                        <input type="password" class="pass-key" name="password" id="registerPassword" required placeholder="Password">
                        <span class="show">SHOW</span>
                    </div>
                    <div class="field">
                        <input type="password" class="pass-key" name="confirm_password" id="confirmPassword" required placeholder="Confirm Password">
                        <span class="show">SHOW</span>
                    </div>
                    <div class="field">
                        <input type="text" name="role" id="role" required placeholder="Role" value="admin" readonly>
                    </div>
                    <div class="field">
                        <input type="submit" value="REGISTER">
                    </div>
                    <div class="signup">Already have an account?
                        <a href="" onclick="showLogin(event)">Login here!</a>
                    </div>
                </form>
            </div>

            <div class="reset-password-form"  style="display: none;">
                <header>Reset Your Password</header>
                <form action="endpoint/forgot-password.php" method="POST">
                    <div class="field">
                        <input type="text" name="email" id="registerUsername" required placeholder="Email Address">
                    </div>
                    <div class="field">
                        <input type="submit" value="RESET">
                    </div>
                    <div class="signup">Already have an account?
                        <a href="" onclick="showLogin(event)">Login here!</a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        // Password visibility toggle
        const showBtns = document.querySelectorAll('.show');
        
        showBtns.forEach(showBtn => {
            showBtn.addEventListener('click', function () {
                const passField = this.previousElementSibling; // Target the associated input field
                if (passField.type === "password") {
                    passField.type = "text";
                    this.textContent = "HIDE";
                } else {
                    passField.type = "password";
                    this.textContent = "SHOW";
                }
            });
        });

        
    // Toggle Login
    function showLogin(event) {
        if (event) event.preventDefault();
        document.querySelector('.login-form').style.display = 'block';
        document.querySelector('.registration-form').style.display = 'none';
        document.querySelector('.reset-password-form').style.display = 'none';
    }

    // Toggle Registration
    function showRegistration(event) {
        if (event) event.preventDefault();
        document.querySelector('.login-form').style.display = 'none';
        document.querySelector('.registration-form').style.display = 'block';
        document.querySelector('.reset-password-form').style.display = 'none';
    }

    // Toggle Reset Password
    function showResetPassword(event) {
        if (event) event.preventDefault();
        document.querySelector('.login-form').style.display = 'none';
        document.querySelector('.registration-form').style.display = 'none';
        document.querySelector('.reset-password-form').style.display = 'block';
    }

    // 🔥 Auto-toggle based on URL parameter
    const params = new URLSearchParams(window.location.search);
    const action = params.get('action');

    if (action === 'signup') {
        showRegistration();
    } else if (action === 'reset') {
        showResetPassword();
    } else {
        showLogin(); // default
    }

    </script>

    
<footer class="page-footer">
    Powered by <span>Finvoicer</span> © 2026
</footer>

</body>

</html>
