<?php
/**
 * Schedule Dashboard
 * - Company scoped
 * - Modern PHP (8+)
 * - Secure prepared statements
 * - "ALL" = current year only
 */

require 'session-master.php';
include 'nav-home2.php';

/* =========================
   SESSION VALIDATION
========================= */
if (!isset($_SESSION['company_id'])) {
    header("Location: sign-in.php");
    exit;
}

$company_id = (int) $_SESSION['company_id'];

/* =========================
   DB CONNECTION
========================= */
$mysqli = new mysqli(
    DATABASE_HOST,
    DATABASE_USER,
    DATABASE_PASS,
    DATABASE_NAME
);

if ($mysqli->connect_error) {
    die("Database connection failed");
}

/* =========================
   FETCH COMPANY INFO
========================= */
$stmt = $mysqli->prepare("
    SELECT company_name, currency
    FROM company
    WHERE id = ?
    LIMIT 1
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$company = $stmt->get_result()->fetch_assoc();

$companyName = $company['company_name'] ?? 'Your Company';
$currency    = $company['currency'] ?? '₦';
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Schedules | <?= htmlspecialchars($companyName) ?></title>
</head>

<body>

<div class="hp-main-layout-content" style="margin-top:10px;margin-left:7px;">
<div class="page-header-modern d-flex align-items-center justify-content-between">
    
    <!-- LEFT: Page title -->
    <h2 class="">

    </h2>

    <!-- RIGHT: User dropdown -->
    <div class="dropdown">
        <button
            class="btn btn-user dropdown-toggle"
            type="button"
            id="userDropdown"
            data-bs-toggle="dropdown"
            aria-expanded="false"
        >
            <i class="fa fa-user-circle me-1"></i>
            <span class="user-name capitalize">
                <img src="images/icon/invoice360-user.png" height=30px; width=30px;>
            </span>
        </button>

        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
            <li>
                <a class="dropdown-item" href="">
                    <i class="fa fa-user me-2"></i>   <?php echo strtok($_SESSION['user_name'], ' ');?> (<?php echo $_SESSION['role']; ?>)
                </a>
            </li>

            <li>
                <a class="dropdown-item" href="Admin/payment-details.php">
                    <i class="fa fa-credit-card"></i> Billing history
                </a>
            </li>

            <li>
                <a class="dropdown-item" href="Admin/company-profile.php">
                    <i class="fa fa-cog me-2"></i> Settings
                </a>
            </li>

            <li><hr class="dropdown-divider"></li>

            <li>
                <a class="dropdown-item text-danger" href="logout.php">
                    <i class="fa fa-sign-out me-2"></i> Sign Out
                </a>
            </li>
        </ul>
    </div>

</div>
    <!-- HEADER -->
<div class="row mb-32">
    <div class="col-12">
        <div class="dashboard-header">
            <div class="header-icon">
                <i class="ti-calendar"></i>
            </div>
            <div class="header-text">
                <h3>Schedules & Renewals</h3>
                <p><?= htmlspecialchars($companyName) ?></p>
            </div>
        </div>
    </div>
</div>

    <div class="row">
        <!-- LEFT PANEL -->
        <div class="col-xl-6 col-xxl-6">
            <div class="card">
                <div class="card-body">

                    <!-- TABS -->
                    <ul class="nav nav-pills hp-overflow-x-auto flex-nowrap mb-3">
                        <li class="nav-item me-4">
                            <button class="nav-link active py-2"
                                    data-bs-toggle="pill"
                                    data-bs-target="#tab-all">
                                ALL (This Year)
                            </button>
                        </li>

                        <li class="nav-item me-4">
                            <button class="nav-link py-2"
                                    data-bs-toggle="pill"
                                    data-bs-target="#tab-month">
                                This Month
                            </button>
                        </li>
                    </ul>

                    <div class="tab-content">

                        <!-- =========================
                             TAB 1: ALL (CURRENT YEAR)
                        ========================== -->
                        <div class="tab-pane fade show active" id="tab-all">
                            <?php
                            $stmt = $mysqli->prepare("
                                SELECT *
                                FROM event_calendar
                                WHERE company_id = ?
                                  AND YEAR(start) = YEAR(CURDATE())
                                ORDER BY start ASC
                                LIMIT 5
                            ");
                            $stmt->bind_param("i", $company_id);
                            $stmt->execute();
                            $results = $stmt->get_result();
                            ?>

                            <div class="table-responsive mt-3">
                                <table class="table align-middle">
                                    <thead class="table-dark">
                                        <tr>
                                            <th>Date</th>
                                            <th>Type</th>
                                            <th>Description</th>
                                            <th>Address</th>
                                            <th width="20%">Amount (<?= htmlspecialchars($currency) ?>)</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    <?php if ($results->num_rows > 0): ?>
                                        <?php while ($row = $results->fetch_assoc()): ?>
                                            <tr>
                                                <td class="fw-bold text-danger">
                                                    <?= date('d M Y', strtotime($row['start'])) ?>
                                                </td>
                                                <td><?= htmlspecialchars($row['schedule_type']) ?></td>
                                                <td><?= htmlspecialchars($row['title']) ?></td>
                                                <td><?= htmlspecialchars($row['client_location']) ?></td>
                                                <td><?= number_format((float)$row['schedule_amount'], 2) ?></td>
                                            </tr>
                                        <?php endwhile; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="5" class="text-center text-muted">
                                                No schedules for this year
                                            </td>
                                        </tr>
                                    <?php endif; ?>

                                    </tbody>
                                </table>
                            </div>

                            <a href="schedule-list.php" class="btn btn-primary w-100 mt-4">
                                View All
                            </a>
                        </div>

                        <!-- =========================
                             TAB 2: THIS MONTH
                        ========================== -->
                        <div class="tab-pane fade" id="tab-month">
                            <?php
                            $stmt = $mysqli->prepare("
                                SELECT *
                                FROM event_calendar
                                WHERE company_id = ?
                                  AND YEAR(start) = YEAR(CURDATE())
                                  AND MONTH(start) = MONTH(CURDATE())
                                ORDER BY start ASC
                                LIMIT 5
                            ");
                            $stmt->bind_param("i", $company_id);
                            $stmt->execute();
                            $results = $stmt->get_result();
                            ?>

                            <div class="table-responsive mt-3">
                                <table class="table align-middle">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Date</th>
                                            <th>Type</th>
                                            <th>Description</th>
                                            <th>Address</th>
                                            <th width="20%">Amount (<?= htmlspecialchars($currency) ?>)</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    <?php if ($results->num_rows > 0): ?>
                                        <?php while ($row = $results->fetch_assoc()): ?>
                                            <tr>
                                                <td class="fw-bold text-danger">
                                                    <?= date('d M Y', strtotime($row['start'])) ?>
                                                </td>
                                                <td><?= htmlspecialchars($row['schedule_type']) ?></td>
                                                <td><?= htmlspecialchars($row['title']) ?></td>
                                                <td><?= htmlspecialchars($row['client_location']) ?></td>
                                                <td><?= number_format((float)$row['schedule_amount'], 2) ?></td>
                                            </tr>
                                        <?php endwhile; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="5" class="text-center text-muted">
                                                No schedules this month
                                            </td>
                                        </tr>
                                    <?php endif; ?>

                                    </tbody>
                                </table>
                            </div>

                            <a href="schedule-list.php" class="btn btn-primary w-100 mt-4">
                                View All
                            </a>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- RIGHT PANEL (CALENDAR) -->
        <div class="col-xl-6 col-xxl-6">
            <div class="card">
                <div class="card-body">
                    <div id="loading">Loading...</div>
                    <div id="calendar"></div>
                </div>
            </div>
        </div>
    </div>

</div>

<?php
$mysqli->close();
include 'footer.php';
?>


<!-- Schedule Details Modal -->
<div class="modal fade" id="eventModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content border-0 shadow-lg">

            <div class="modal-header">
                <h5 class="modal-title" id="eventTitle">Schedule Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <div class="mb-3">
                    <strong>Date:</strong>
                    <div id="eventDate" class="text-muted"></div>
                </div>

                <div class="mb-3">
                    <strong>Type:</strong>
                    <div id="eventType"></div>
                </div>

                <div class="mb-3">
                    <strong>Description:</strong>
                    <div id="eventDescription"></div>
                </div>

                <div class="mb-3">
                    <strong>Location:</strong>
                    <div id="eventLocation"></div>
                </div>

                <div class="mb-3">
                    <strong>Amount:</strong>
                    <div id="eventAmount"></div>
                </div>
            </div>

            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">
                    Close
                </button>
            </div>

        </div>
    </div>
</div>


          

    <!-- Plugin -->
    <script src="app-assets/js/plugin/jquery.min.js"></script>
    <script src="app-assets/js/plugin/bootstrap.bundle.min.js"></script>
    <script src="app-assets/js/plugin/swiper-bundle.min.js"></script>
    <script src="app-assets/js/plugin/jquery.mask.min.js"></script>
    <script src="app-assets/js/plugin/autocomplete.min.js"></script>
    <script src="app-assets/js/plugin/moment.min.js"></script>

    <!-- Layouts -->
    <script src="app-assets/js/layouts/header-search.js"></script>
    <script src="app-assets/js/layouts/sider.js"></script>
    <script src="app-assets/js/components/input-number.js"></script>

    <!-- Base -->
    <script src="app-assets/js/base/index.js"></script>
    <!-- Customizer -->
    <script src="app-assets/js/customizer.js"></script>

    <!-- Custom -->
    <script src="assets/js/main.js"></script>


  
</body>



</html>