
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Invoice <?= htmlspecialchars($invoice['invoice']) ?></title>

<style>
body { font-family: DejaVu Sans, sans-serif; }

.table-clean { width:100%; border-collapse:collapse; font-size:13px; }
.table-clean td, .table-clean th { padding:6px 4px; }

.table-summary { width:100%; border-collapse:collapse; margin-top:10px; font-size:12px; }
.table-summary th { background:#f0f0f0; padding:8px; }
.table-summary td { padding:8px; border-bottom:1px solid #eee; }

.total-box td { background:#000; color:#fff; font-weight:bold; }
.section-title { font-weight:bold; font-size:14px; margin-bottom:4px; }
</style>
</head>

<body>

<?php if (!empty($invoice['status'])): ?>
<div style="
    position:fixed;
    top:35%;
    left:0;
    width:100%;
    font-size:120px;
    font-weight:bold;
    color:rgba(0,0,0,0.05);
    text-align:center;
    transform:rotate(-30deg);
">
<?= strtoupper($invoice['status']) ?>
</div>
<?php endif; ?>

<table width="100%" style="margin-bottom:20px;">
<tr>
<td width="50%">
<?php if ($base64_logo): ?>
<img src="<?= $base64_logo ?>" width="200">
<?php endif; ?>
</td>
<td width="50%" align="right">
<h1><?= strtoupper($invoice['invoice_type']) ?></h1>
</td>
</tr>
</table>

<table class="table-clean">
<tr>
<td width="60%"></td>
<td align="right"><b>Invoice No:</b></td>
<td align="right"><?= htmlspecialchars($invoice['invoice']) ?></td>
</tr>
<tr>
<td></td>
<td align="right"><b>Billing Date:</b></td>
<td align="right"><?= date('d M Y', strtotime($invoice['invoice_date'])) ?></td>
</tr>
<tr>
<td></td>
<td align="right"><b>Due Date:</b></td>
<td align="right"><?= date('d M Y', strtotime($invoice['invoice_due_date'])) ?></td>
</tr>
<tr>
<td></td>
<td align="right"><b>Total Amount:</b></td>
<td align="right">₦<?= number_format($invoice['total'], 2) ?></td>
</tr>
</table>

<br>

<table class="table-clean">
<tr>
<td width="33%" valign="top">
<div class="section-title">OUR DETAILS</div>
<b><?= htmlspecialchars($company['company_name']) ?></b><br>
<?= nl2br(htmlspecialchars($company['company_address'])) ?><br>
<?= htmlspecialchars($company['company_town']) ?>, <?= htmlspecialchars($company['company_state']) ?><br>
<?= htmlspecialchars($company['company_email']) ?><br>
<?= htmlspecialchars($company['company_phone']) ?>
</td>

<td width="33%" valign="top">
<div class="section-title">BILLING TO</div>
<b><?= htmlspecialchars($invoice['name']) ?></b><br>
<?= htmlspecialchars($invoice['address_1']) ?><br>
<?= htmlspecialchars($invoice['town']) ?>, <?= htmlspecialchars($invoice['county']) ?><br>
<?= htmlspecialchars($invoice['postcode']) ?>
</td>

<td width="33%" valign="top">
<div class="section-title">PAY TO</div>
Bank: <?= htmlspecialchars($company['bank_name']) ?><br>
Account No: <?= htmlspecialchars($company['account_no']) ?><br>
Account Name: <?= htmlspecialchars($company['account_name']) ?>
</td>
</tr>
</table>

<br>

<table class="table-summary">
<thead>
<tr>
<th>Description</th>
<th width="10%">Qty</th>
<th width="15%">Unit Price</th>
<th width="15%">Total</th>
</tr>
</thead>

<tbody>
<?php foreach ($items as $item): ?>
<tr>
<td>
<b><?= htmlspecialchars($item['product']) ?></b><br>
<span style="font-size:11px;">
<?= htmlspecialchars($item['product_description']) ?>
</span>
</td>
<td align="right"><?= $item['qty'] ?></td>
<td align="right"><?= number_format($item['price'], 2) ?></td>
<td align="right"><?= number_format($item['subtotal'], 2) ?></td>
</tr>
<?php endforeach; ?>
</tbody>

<tfoot>
<tr>
<td colspan="2"></td>
<td align="right"><b>Subtotal</b></td>
<td align="right"><?= number_format($invoice['subtotal'], 2) ?></td>
</tr>
<tr>
<td colspan="2"></td>
<td align="right"><b>Discount</b></td>
<td align="right"><?= number_format($invoice['discount'], 2) ?></td>
</tr>
<tr>
<td colspan="2"></td>
<td align="right"><b>Tax</b></td>
<td align="right"><?= number_format($invoice['vat'], 2) ?></td>
</tr>
<tr class="total-box">
<td colspan="2"></td>
<td align="right">TOTAL</td>
<td align="right">₦<?= number_format($invoice['total'], 2) ?></td>
</tr>
</tfoot>
</table>

<br><br>

<b>NOTES</b>
<div style="font-size:12px;">
<?= nl2br(htmlspecialchars($company['terms'])) ?>
</div>

</body>
</html>