<?php
require('session-master.php');
require('functions.php');

/* --------------------------------------------
   SESSION & INPUT VALIDATION
-------------------------------------------- */
if (!isset($_SESSION['company_id'])) {
    echo "<script>
        alert('Company context missing. Please re-login.');
        window.location.href = 'sign-in.php';
    </script>";
    exit;
}

$company_id = (int) $_SESSION['company_id'];

if (empty($_GET['id'])) {
    echo "<script>
        alert('Invalid ID');
        window.location.href = 'expense-download.php';
    </script>";
    exit;
}

$expense_id = (int) $_GET['id'];

/* --------------------------------------------
   DB CONNECTION
-------------------------------------------- */
$mysqli = new mysqli(
    DATABASE_HOST,
    DATABASE_USER,
    DATABASE_PASS,
    DATABASE_NAME
);

if ($mysqli->connect_error) {
    die('Database error');
}

/* --------------------------------------------
   FETCH EXPENSE
-------------------------------------------- */
$stmt = $mysqli->prepare("
    SELECT *
    FROM expenses
    WHERE id = ?
      AND company_id = ?
    LIMIT 1
");
$stmt->bind_param("ii", $expense_id, $company_id);
$stmt->execute();
$expense = $stmt->get_result()->fetch_assoc();

if (!$expense) {
    echo "<script>
        alert('Not found or Access DENIED.');
        window.location.href = 'expense-download.php';
    </script>";
    exit;
}

/* --------------------------------------------
   FETCH COMPANY
-------------------------------------------- */
$stmt = $mysqli->prepare("
    SELECT *
    FROM company
    WHERE id = ?
    LIMIT 1
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$company = $stmt->get_result()->fetch_assoc();

/* --------------------------------------------
   LOGO PATH (NORMAL IMAGE)
-------------------------------------------- */
$logo_path = '';
if (!empty($company['company_logo'])) {
    $logo_path = 'images/' . $company['company_logo'];
}

$mysqli->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" sizes="32x32" href="app-assets/favicon/inv.png">
<link rel="icon" type="image/png" sizes="16x16" href="app-assets/favicon/inv.png">
<title>Expense <?= htmlspecialchars($expense['expense_id']) ?></title>

<style>
body {
    font-family: 'Segoe UI', Arial, sans-serif;
    font-size: 13px;
    background: #f5f6fa;
    padding: 30px;
}

.container {
    max-width: 900px;
    margin: auto;
    background: #fff;
    padding: 30px;
    box-shadow: 0 10px 25px rgba(0,0,0,.08);
}

table {
    width: 100%;
    border-collapse: collapse;
}

.header h1 {
    margin: 0;
}

.info-box,
.footer-box,
.footer-box1 {
    border: 1px solid #e5e7eb;
    margin-top: 20px;
}

.info-box td {
    padding: 12px;
    border-bottom: 1px solid #e5e7eb;
}

.info-box tr:last-child td {
    border-bottom: none;
}

.label {
    font-weight: 600;
    width: 35%;
    color: #374151;
}

.label1 {
    font-weight: 600;
    font-size: 15px;
}

.amount-box {
    background: #111827;
    color: #fff;
}

.amount-box td {
    padding: 14px;
    font-size: 15px;
    font-weight: bold;
}

.footer-box td {
    padding: 25px;
    text-align: center;
}

.footer-title {
    display: block;
    font-weight: 600;
    margin-bottom: 15px;
}

/* =======================
   ACTION BUTTON BAR
======================= */
.action-bar {
    max-width: 850px;
    margin: 0 auto 15px auto;
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0 10px;
}

.action-left,
.action-right {
    display: flex;
    gap: 10px;
}

.action-btn {
    padding: 8px 14px;
    font-size: 13px;
    border-radius: 4px;
    border: none;
    cursor: pointer;
    text-decoration: none;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    gap: 6px;
}

.btn-back {
    background: #e5e7eb;
    color: #111;
}

.btn-download {
    background: #0d6efd;
    color: #fff;
}

.btn-share {
    background: #198754;
    color: #fff;
}

.action-btn:hover {
    opacity: 0.9;
}

/* Hide buttons when printing */
@media print {
    .action-bar {
        display: none;
    }
}
</style>
</head>

<body>

<div class="container">
    <!-- ACTION BUTTONS -->
<div class="action-bar">
    <div class="action-left">
        <a href="javascript:history.back()" class="action-btn btn-back">
            ← Back
        </a>
    </div>

    <div class="action-right">
        <!-- Download PDF -->
        <a href="expense-download.php?id=<?= $expense['id'] ?>" 
           class="action-btn btn-download">
            ⬇ Download
        </a>

       
    </div>
</div>
<!-- HEADER -->
<table class="header">
<tr>
<td width="50%">
<?php if ($logo_path && file_exists($logo_path)): ?>
    <img src="<?= htmlspecialchars($logo_path) ?>" width="180">
<?php endif; ?>
</td>
<td width="50%" align="right">
    <h1>Transaction Details</h1>
</td>
</tr>
</table>

<!-- CREATED BY -->
<table class="footer-box1">
<tr>
<td class="label1">
    Created By: <?= htmlspecialchars($expense['created_by']) ?>
</td>
</tr>
</table>

<!-- DETAILS -->
<table class="info-box">
<tr>
<td class="label">Transaction ID</td>
<td><?= htmlspecialchars($expense['expense_id']) ?></td>
</tr>
<tr>
<td class="label">Reference No</td>
<td><?= htmlspecialchars($expense['reference_no']) ?></td>
</tr>
<tr>
<td class="label">Transaction Date</td>
<td><?= date('d M Y', strtotime($expense['expense_date'])) ?></td>
</tr>
<tr>
<td class="label">Transaction Type</td>
<td><?= ucfirst(htmlspecialchars($expense['transaction_type'])) ?></td>
</tr>
<tr>
<td class="label">Transaction Mode</td>
<td><?= ucfirst(htmlspecialchars($expense['transaction_mode'])) ?></td>
</tr>
<tr>
<td class="label">Status</td>
<td><?= ucfirst(htmlspecialchars($expense['transaction_status'])) ?></td>
</tr>
<tr>
<td class="label">Description</td>
<td><?= nl2br(htmlspecialchars($expense['expense_desc'])) ?></td>
</tr>
<tr class="amount-box">
<td class="label">Amount</td>
<td><?= htmlspecialchars($company['currency']) . number_format($expense['expense_amount'], 2) ?></td>
</tr>
</table>

<!-- SIGNATURES -->
<table class="footer-box">
<tr>
<td width="50%">
    <span class="footer-title">Authorised By</span>
    <?= htmlspecialchars($expense['authorised_by']) ?>
</td>
<td width="50%">
    <span class="footer-title">Authorised By</span>
    <?= htmlspecialchars($expense['authorised_by2']) ?>
</td>
</tr>
</table>

</div>

</body>
</html>
