<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Invoice360 Email Verification</title>
<link rel="apple-touch-icon" sizes="180x180" href="../app-assets/favicon/inv.png">
    <link rel="icon" type="image/png" sizes="32x32" href="../app-assets/favicon/inv.png">
    <link rel="icon" type="image/png" sizes="16x16" href="../app-assets/favicon/inv.png">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


<style>
    body {
        margin: 0;
        height: 100vh;
        background: linear-gradient(135deg, #f5f7fb, #eef2ff);
        display: flex;
        align-items: center;
        justify-content: center;
        font-family: 'Segoe UI', Tahoma, sans-serif;
    }

    .verify-card {
        background: #ffffff;
        width: 100%;
        max-width: 420px;
        border-radius: 14px;
        box-shadow: 0 25px 50px rgba(0,0,0,0.2);
        padding: 30px;
        animation: fadeIn 0.5s ease-in-out;
    }

    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .verify-card h2 {
        margin: 0 0 10px;
        font-size: 26px;
        color: #2c5364;
        text-align: center;
    }

    .verify-card p {
        font-size: 14px;
        color: #555;
        line-height: 1.6;
        text-align: center;
        margin-bottom: 25px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-group input {
        width: 100%;
        padding: 14px;
        font-size: 20px;
        letter-spacing: 6px;
        text-align: center;
        border-radius: 8px;
        border: 1px solid #ccc;
        outline: none;
        transition: border 0.3s;
    }

    .form-group input:focus {
        border-color: #2c5364;
    }

    .btn {
        width: 100%;
        padding: 14px;
        border: none;
        border-radius: 8px;
        font-size: 15px;
        font-weight: 600;
        cursor: pointer;
        transition: background 0.3s, transform 0.2s;
    }

    .btn-primary {
        background: #2c5364;
        color: #fff;
    }

    .btn-primary:hover {
        background: #1e3c52;
        transform: translateY(-1px);
    }

    .btn-secondary {
        margin-top: 12px;
        background: #f1f1f1;
        color: #444;
    }

    .btn-secondary:hover {
        background: #e2e2e2;
    }

    .footer-text {
        margin-top: 15px;
        font-size: 12px;
        color: #777;
        text-align: right;
    }



    .verify-card form {
    width: 100%;
    margin: 0;
}

.verify-card form * {
    box-sizing: border-box;
}

.verify-card .form-group {
    width: 100%;
    margin: 0 0 20px 0;
}

.verify-card button {
    display: block;
    width: 100%;
}

.verify-card p,
.verify-card .footer-text {
    text-align: center;
}

.verify-card input,
.verify-card button {
    text-align: center;
}

/* ============================
   PAGE FOOTER
============================= */

.page-footer {
    position: fixed;
    bottom: 18px;
    width: 100%;
    text-align: center;
    font-size: 13px;
    color: #64748b;
    letter-spacing: 0.3px;
}

.page-footer strong {
    color: #1d1d1eff;
    font-weight: 600;
}


</style>
</head>

<body>

<div class="verify-card">

    <h2>Invoice360 Email Verification</h2>

    <p>
        Please enter the One-Time Password (OTP) sent to your email address.
        This code is valid for a limited time.
    </p>

    <form action="verify-email-process.php" method="POST">
        <input type="hidden" name="email" value="<?= htmlspecialchars($_GET['email']) ?>">

        <div class="form-group">
            <input type="text" name="otp" maxlength="6" required>
        </div>

        <button type="submit" class="btn btn-primary">
            Verify Email
        </button>
    </form>

    <form action="resend-otp.php" method="POST">
        <input type="hidden" name="email" value="<?= htmlspecialchars($_GET['email']) ?>">
        <button type="submit" class="btn btn-secondary">
            Resend OTP
        </button>
    </form>

    <div class="footer-text">
        Didn’t receive the code? Check your spam folder.
    </div>

</div>

<footer class="page-footer">
    Powered by <strong>invoice360.</strong>
</footer>

</body>
</html>
