<?php
require '../session-master.php';
require '../includes/config.php';
require 'smtp_mail.php'; // where sendEmailToAdmins() lives
require 'helpers.php';

if ($_SESSION['role'] !== 'super_admin') {
    exit('Unauthorized');
}

$company_id = (int) $_SESSION['company_id'];
$senderName = $_SESSION['user_name'];

$subject  = trim($_POST['subject'] ?? '');
$message  = trim($_POST['message'] ?? '');
$replyTo  = trim($_POST['reply_to'] ?? '');

if ($subject === '' || $message === '') {
    jsAlert(
    'Error',
    'You forgot to add a subject. Please try again.',
    'error',
    () => history.back()
);

    exit;
}

/* =========================
   EMAIL TEMPLATE
========================= */
$htmlBody = "
<div>
    <p>{$message}</p>
    
</div>
";

$sent = sendEmailToAdmins(
    $mysqli,
    $company_id,
    $subject,
    $htmlBody,
    $replyTo ?: null,
    $senderName
);

if ($sent) {
   jsAlert(
        'Email Sent to Admins',
        'Congratulations',
        'success',
        '../master-sub.php'
    );
} else {
   jsAlert(
        'System Error',
        'Unable send Email. Please try again later.',
        'error',
        '../master-send-admin-email.php'
    );
}
exit;
