<?php
require 'nav-home2.php';

if (!isset($_SESSION['company_id'])) {
    header('Location: sign-in.php');
    exit;
}

$company_id = (int) $_SESSION['company_id'];
$year       = (int) date('Y');
$name       =  $_SESSION['user_name'];


/* =========================
   COMPANY INFO
========================= */
$stmt = $mysqli->prepare("
    SELECT company_name, currency
    FROM company
    WHERE id = ?
    LIMIT 1
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$company = $stmt->get_result()->fetch_assoc();

$companyName = $company['company_name'];
$currency    = $company['currency'];

 /* =========================
   ustomer
========================= */
    
$stmt = $mysqli->prepare("
SELECT COUNT(*) 
FROM store_customers 
WHERE company_id = ?
");

$stmt->bind_param("i", $company_id);
$stmt->execute();
$stmt->bind_result($customerCount);
$stmt->fetch();
$stmt->close();




/* =========================
   MONTHLY FINANCIAL STATS
========================= */
$monthly = array_fill(1, 12, [
    'income'  => 0.0,
    'expense' => 0.0,
    'balance' => 0.0
]);



$stmt = $mysqli->prepare("
    SELECT
        MONTH(expense_date) AS m,
        SUM(CASE WHEN transaction_type = 'income' THEN expense_amount ELSE 0 END) AS income,
        SUM(CASE WHEN transaction_type = 'expenditure' THEN expense_amount ELSE 0 END) AS expense
    FROM expenses
    WHERE company_id = ?
      AND YEAR(expense_date) = ?
    GROUP BY MONTH(expense_date)
");

$stmt->bind_param("ii", $company_id, $year);
$stmt->execute();
$res = $stmt->get_result();

while ($row = $res->fetch_assoc()) {
    $m = (int)$row['m'];
    $income  = (float)$row['income'];
    $expense = (float)$row['expense'];
    $balance = $income - $expense;

    $monthly[$m] = [
        'income'  => $income,
        'expense' => $expense,
        'balance' => $income - $expense
    ];
}


$currentMonth = (int) date('n'); // 1–12
$monthIncome  = $monthly[$currentMonth]['income']  ?? 0;
$monthExpense = $monthly[$currentMonth]['expense'] ?? 0;
$monthBalance = $monthly[$currentMonth]['balance'] ?? 0;

/* =========================
   YEAR SUMMARY
========================= */
$year = (int) date('Y');

$stmt = $mysqli->prepare("
    SELECT
        COUNT(*) AS total_txn,

        COUNT(CASE WHEN transaction_type = 'income' THEN 1 END) AS income_count,
        COUNT(CASE WHEN transaction_type = 'expenditure' THEN 1 END) AS expense_count,

        COALESCE(SUM(CASE WHEN transaction_type = 'income' THEN expense_amount END), 0) AS income,
        COALESCE(SUM(CASE WHEN transaction_type = 'expenditure' THEN expense_amount END), 0) AS expense
    FROM expenses
    WHERE company_id = ?
      AND YEAR(expense_date) = ?
");

$stmt->bind_param("ii", $company_id, $year);
$stmt->execute();
$summary = $stmt->get_result()->fetch_assoc();

/* =========================
   NORMALIZED VARIABLES
========================= */
$yearIncome       = (float) $summary['income'];
$yearExpense      = (float) $summary['expense'];
$yearBalance      = $yearIncome - $yearExpense;

$yearTotalCount   = (int) $summary['total_txn'];
$yearIncomeCount  = (int) $summary['income_count'];
$yearExpenseCount = (int) $summary['expense_count'];

/* =========================
   FORMATTER
========================= */
function money($amount): string {
    return number_format((float) ($amount ?? 0), 2);
}


$monthlyBalances = [];

for ($i = 1; $i <= 12; $i++) {
    $monthlyBalances[] = round((float)($monthly[$i]['balance'] ?? 0), 2);
}


/* =========================
   LATEST Transactions
========================= */
$stmt = $mysqli->prepare("
    SELECT *
    FROM expenses
    WHERE company_id = ?
    ORDER BY expense_date DESC
    LIMIT 5
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$latestTransactions = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

/* =========================
   LATEST Vouchers
========================= */
$stmt = $mysqli->prepare("
    SELECT *
    FROM vouchers
    WHERE company_id = ?
    ORDER BY voucher_date DESC
    LIMIT 5
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$latestVouchers = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);




//Invoice scripts
/* =========================
   MONTHLY INVOICE STATS (ONE QUERY)
========================= */
$monthly = array_fill(1, 12, [
    'total'   => 0,
    'paid'    => 0,
    'pending' => 0
]);

$stmt = $mysqli->prepare("
    SELECT 
        MONTH(invoice_date) AS m,
        SUM(total) AS total,
        SUM(CASE WHEN status='Paid' THEN total ELSE 0 END) AS paid,
        SUM(CASE WHEN status='Pending' THEN total ELSE 0 END) AS pending
    FROM invoices
    WHERE company_id = ?
      AND YEAR(invoice_date) = YEAR(CURDATE())
    GROUP BY MONTH(invoice_date)
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$res = $stmt->get_result();

while ($row = $res->fetch_assoc()) {
    $m = (int) $row['m'];

        $pending1  = (float)$row['pending'];
        $paid1 = (float)$row['paid'];
    $monthly[$m] = [

        'total'   => (float) $row['total'],
        'paid'    => (float) $row['paid'],
        'pending' => (float) $row['pending']
    ];
}


/* =========================
   CURRENT MONTH COUNTS
========================= */
$stmt = $mysqli->prepare("
    SELECT
        COUNT(*) AS total_count,
        COUNT(CASE WHEN status='Paid' THEN 1 END) AS paid_count,
        COUNT(CASE WHEN status='Pending' THEN 1 END) AS pending_count
    FROM invoices
    WHERE company_id = ?
      AND YEAR(invoice_date) = YEAR(CURDATE())
      AND MONTH(invoice_date) = MONTH(CURDATE())
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$monthCounts = $stmt->get_result()->fetch_assoc();


/* =========================
   CHART DATA (SAFE FOR JS)
========================= */
$chartTotal   = [];
$chartPaid    = [];
$chartPending = [];

for ($m = 1; $m <= 12; $m++) {
    $chartTotal[]   = $monthly[$m]['total'];
    $chartPaid[]    = $monthly[$m]['paid'];
    $chartPending[] = $monthly[$m]['pending'];
}


/* ========================= 
   YEAR SUMMARY
========================= */
$stmt = $mysqli->prepare("
    SELECT
        COUNT(*) AS total_count,

        COUNT(CASE WHEN status = 'Paid' THEN 1 END) AS paid_count,
        COUNT(CASE WHEN status = 'Pending' THEN 1 END) AS pending_count,

        COALESCE(SUM(total), 0) AS total_amount,
        COALESCE(SUM(CASE WHEN status = 'Paid' THEN total END), 0) AS paid_amount,
        COALESCE(SUM(CASE WHEN status = 'Pending' THEN total END), 0) AS pending_amount

    FROM invoices
    WHERE company_id = ?
      AND YEAR(invoice_date) = YEAR(CURDATE())
");

$stmt->bind_param("i", $company_id);
$stmt->execute();
$summary = $stmt->get_result()->fetch_assoc();

/* =========================
   LATEST INVOICES
========================= */
$stmt = $mysqli->prepare("
    SELECT i.invoice, i.invoice_date, i.invoice_type, i.total, i.status, c.name
    FROM invoices i
    JOIN customers c 
        ON c.invoice = i.invoice 
       AND c.company_id = i.company_id
    WHERE i.company_id = ?
    ORDER BY i.invoice_date DESC
    LIMIT 5
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$latestInvoices = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);


$currentMonth = (int) date('n');

$totalAmount   = $monthly[$currentMonth]['total'];
$paidAmount    = $monthly[$currentMonth]['paid'];
$pendingAmount = $monthly[$currentMonth]['pending'];

$totalCount    = (int) ($monthCounts['total_count'] ?? 0);
$paidCount     = (int) ($monthCounts['paid_count'] ?? 0);
$pendingCount  = (int) ($monthCounts['pending_count'] ?? 0);
?>


            <div style="margin-top: ;  margin-left: 10px;" class="hp-main-layout-content">
                <div class="row mb-32 g-32">
    <div class="page-header-modern d-flex align-items-center justify-content-between">
    
    <!-- LEFT: Page title -->
    <h2 class="">

    </h2>

    <!-- RIGHT: User dropdown -->
    <div class="dropdown">
        <button
            class="btn btn-user dropdown-toggle"
            type="button"
            id="userDropdown"
            data-bs-toggle="dropdown"
            aria-expanded="false"
        >
            <i class="fa fa-user-circle me-1"></i>
            <span class="user-name capitalize">
                <img src="images/icon/invoice360-user.png" height=30px; width=30px;>
            </span>
        </button>

        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
            <li>
                <a class="dropdown-item" href="">
                    <i class="fa fa-user me-2"></i>   <?php echo strtok($_SESSION['user_name'], ' ');?> (<?php echo $_SESSION['role']; ?>)
                </a>
            </li>

            <li>
                <a class="dropdown-item" href="Admin/payment-details.php">
                    <i class="fa fa-credit-card"></i> Billing history
                </a>
            </li>

            <li>
                <a class="dropdown-item" href="Admin/company-profile.php">
                    <i class="fa fa-cog me-2"></i> Settings
                </a>
            </li>

            <li><hr class="dropdown-divider"></li>

            <li>
                <a class="dropdown-item text-danger" href="logout.php">
                    <i class="fa fa-sign-out me-2"></i> Sign Out
                </a>
            </li>
        </ul>
    </div>

</div>
                    <div style="margin-top: -15px;" class="col flex-grow-1 overflow-hidden">
                        <div class="row g-32">
                        <div class="col-12">
                     <div class="row align-items-center justify-content-between g-24">
                            <div class="col-12">
                                <h3>Welcome, <?php echo $name ?>👋</h3>
                                <p class="hp-p1-body mb-0">Your status and analytics of <b><?php echo $companyName ?></b> for year <b><?php echo date('Y');?> </b> till date are here</p>
                            </div>
                            
                            
                        </div>
                       </div>

                                <div class="col-12">
                                <div class="row g-32">
                                    <div class="col-md-4 col-6">
                                        <div class="card hp-dashboard-feature-card hp-border-color-black-0 hp-border-color-dark-80 hp-cursor-pointer">
                                            <div class="card-body">
                                                <div class="d-flex align-items-center justify-content-center hp-dashboard-feature-card-icon rounded-3 hp-bg-black-20 hp-bg-dark-80" style="width: 48px; height: 48px;">
                                                    <img src="images/icon/income.png" height= 30px; width="30px">
                                                </div>

                                                <div class="d-flex mt-12">
                                                    <span class="h4 mb-0 d-block hp-text-color-black-bg hp-text-color-dark-0 fw-medium me-4"> Income </span>
                                                    <div>
                                                        <svg class="hp-text-color-success-1" xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none">
                                                            <path fill="currentColor" d="M16.19 2H7.81C4.17 2 2 4.17 2 7.81v8.37C2 19.83 4.17 22 7.81 22h8.37c3.64 0 5.81-2.17 5.81-5.81V7.81C22 4.17 19.83 2 16.19 2zm1.34 5.53l-7.72 7.72h3.02c.41 0 .75.34.75.75s-.34.75-.75.75H8c-.41 0-.75-.34-.75-.75v-4.83c0-.41.34-.75.75-.75s.75.34.75.75v3.02l7.72-7.72c.15-.15.34-.22.53-.22s.38.07.53.22c.29.29.29.77 0 1.06z"></path>
                                                        </svg>
                                                    </div>
                                                </div>

                                                <span class="hp-caption mt-4 d-block fw-medium hp-text-color-black-30">
                                                <?= $yearIncomeCount ?> Transactions
                                                </span>

                                                <span style="font-weight:700;" class="d-block mt-12 mb-8 h6"> 
                                                <?= $currency?><?= money($yearIncome) ?>   
                                                
                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4 col-6">
                                        <div class="card hp-dashboard-feature-card hp-border-color-black-0 hp-border-color-dark-80 hp-cursor-pointer">
                                            <div class="card-body">
                                                <div class="d-flex align-items-center justify-content-center hp-dashboard-feature-card-icon rounded-3 hp-bg-black-20 hp-bg-dark-80" style="width: 48px; height: 48px;">
                                                    <img src="images/icon/expense.png" height= 30px; width="30px">
                                                </div>

                                                <div class="d-flex mt-12">
                                                    <span class="h4 mb-0 d-block hp-text-color-black-bg hp-text-color-dark-30 fw-medium me-4"> Expenses </span>
                                                    <div>
                                                        <svg class="hp-text-color-danger-1" xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none">
                                                            <path fill="currentColor" d="M16.19 2H7.81C4.17 2 2 4.17 2 7.81v8.37C2 19.83 4.17 22 7.81 22h8.37c3.64 0 5.81-2.17 5.81-5.81V7.81C22 4.17 19.83 2 16.19 2zm1.06 10.33c0 .41-.34.75-.75.75s-.75-.34-.75-.75V9.31l-7.72 7.72c-.15.15-.34.22-.53.22s-.38-.07-.53-.22a.754.754 0 010-1.06l7.72-7.72h-3.02c-.41 0-.75-.34-.75-.75s.34-.75.75-.75h4.83c.41 0 .75.34.75.75v4.83z"></path>

                                                        </svg>
                                                    </div>
                                                </div>
                                                <?= $yearExpenseCount  ?> 
                                            Transactions
                                            </span>

                                            <span style="font-weight:700;" class="d-block mt-12 mb-8 h6"> 
                                            <?= $currency ?><?= money($yearExpense) ?>   
                                             </span>
                                                
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4 col-6">
                                        <div class="card hp-dashboard-feature-card hp-border-color-black-0 hp-border-color-dark-80 hp-cursor-pointer">
                                            <div class="card-body">
                                                <div class="d-flex align-items-center justify-content-center hp-dashboard-feature-card-icon rounded-3 hp-bg-black-20 hp-bg-dark-80" style="width: 48px; height: 48px;">
                                                    <img src="images/icon/earning.png" height= 30px; width="30px">
                                                </div>

                                                <div class="d-flex mt-12">
                                                    <span class="h4 mb-0 d-block hp-text-color-black-bg hp-text-color-dark-0 fw-medium me-4"> Earnings </span>
                                                                                                        <div>
                                                        <svg class="hp-text-color-secondary-1" xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none">
                                                            <path fill="currentColor" d="M16.19 2H7.81C4.17 2 2 4.17 2 7.81v8.37C2 19.83 4.17 22 7.81 22h8.37c3.64 0 5.81-2.17 5.81-5.81V7.81C22 4.17 19.83 2 16.19 2zm1.34 5.53l-7.72 7.72h3.02c.41 0 .75.34.75.75s-.34.75-.75.75H8c-.41 0-.75-.34-.75-.75v-4.83c0-.41.34-.75.75-.75s.75.34.75.75v3.02l7.72-7.72c.15-.15.34-.22.53-.22s.38.07.53.22c.29.29.29.77 0 1.06z"></path>
                                                        </svg>
                                                    </div>
                                                </div>

                                                <span style="font-weight:700;" class="hp-caption mt-4 d-block fw-medium hp-text-color-black-30"> Year to Date </span>
                                                <span style="font-weight:700;" class="d-block mt-12 mb-8 h6"> 
                                                <?= $currency ?><?= money($yearBalance)   ?>                                             
                                                
                                                 
                                                 
                                                                                        
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                
                            
                                    <div class="col-md-4 col-6">
                                        <div class="card hp-dashboard-feature-card hp-border-color-black-0 hp-border-color-dark-80 hp-cursor-pointer">
                                            <div class="card-body">
                                                <div class="d-flex align-items-center justify-content-center hp-dashboard-feature-card-icon rounded-3 hp-bg-black-20 hp-bg-dark-80" style="width: 48px; height: 48px;">
                                                    <img src="images/icon/invoice.png" height= 30px; width="30px">
                                                </div>

                                                <div class="d-flex mt-12">
                                                    <span class="h4 mb-0 d-block hp-text-color-black-bg hp-text-color-dark-0 fw-medium me-4">Invoices </span>
                                                    <div>
                                                        
                                                    </div>
                                                </div>

                                                <span class="hp-caption mt-4 d-block fw-medium hp-text-color-black-30">
                                                <?= (int)$summary['total_count'] ?> Invoices Created
                                                </span>

                                                <span style="font-weight:700;" class="d-block mt-12 mb-8 h6"> 
                                                <?= $currency?><?= money($summary['total_amount']) ?>    
                                                
                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4 col-6">
                                        <div class="card hp-dashboard-feature-card hp-border-color-black-0 hp-border-color-dark-80 hp-cursor-pointer">
                                            <div class="card-body">
                                                <div class="d-flex align-items-center justify-content-center hp-dashboard-feature-card-icon rounded-3 hp-bg-black-20 hp-bg-dark-80" style="width: 48px; height: 48px;">
                                                    <img src="images/icon/pending.png" height= 30px; width="30px">
                                                </div>

                                                <div class="d-flex mt-12">
                                                    <span class="h4 mb-0 d-block hp-text-color-black-bg hp-text-color-dark-30 fw-medium me-4">Pending </span>
                                                    <div>
                                                       
                                                    </div>
                                                </div>
                                                <?= (int)$summary['pending_count'] ?> 
                                            Pending Invoices
                                            </span>

                                            <span style="font-weight:700;" class="d-block mt-12 mb-8 h6"> 
                                            <?= $currency ?><?= money($summary['pending_amount']) ?>    
                                            
                                             </span>
                                                
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4 col-6">
                                        <div class="card hp-dashboard-feature-card hp-border-color-black-0 hp-border-color-dark-80 hp-cursor-pointer">
                                            <div class="card-body">
                                                <div class="d-flex align-items-center justify-content-center hp-dashboard-feature-card-icon rounded-3 hp-bg-black-20 hp-bg-dark-80" style="width: 48px; height: 48px;">
                                                    <img src="images/icon/paid-invoice.png" height= 30px; width="30px">
                                                </div>

                                                <div class="d-flex mt-12">
                                                    <span class="h4 mb-0 d-block hp-text-color-black-bg hp-text-color-dark-0 fw-medium me-4">Paid </span>
                                                                                                        <div>
                                                        
                                                    </div>
                                                </div>

                                                <span class="hp-caption mt-4 d-block fw-medium hp-text-color-black-30"><?= (int)$summary['pending_count'] ?> Paid Invoices</span>
                                                <span style="font-weight:700;" class="d-block mt-12 mb-8 h6"> 
                                                                                              
                                                <?= $currency ?><?= money($summary['pending_amount']) ?>     
                                                                                
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                        <div class="card hp-card-6 hp-text-color">
                                            <div class="card-body">
                                                <div class="row justify-content-between mb-16">
                                                    <div class="col-6">
                                                        <h4 class="me-8"><?php echo date('Y');?> Performance</h4>
                                                    </div>
                                                </div>

                                                <div
                                                 id="dashboard-analytics-balance-chart">
                                                
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                            

                            <div class="col-12">
                                <div style="margin-top:30px; margin-bottom:px;" class="row align-items-center justify-content-between">
                                    <div class="col-12">
                                   
                                        
                                    </div>

                                    <div class="col"></div>
                                </div>

                                <div class="col-12">
                                        <div class="card hp-card-6 hp-text-color">
                                            <div class="card-body">
                                                <div class="row justify-content-between mb-16">
                                                    <div class="col-6">
                                                        <h4 class="me-8"><?php echo date('Y');?> Invoicing Performance</h4>
                                                    </div>
                                                </div>

                                                <div
                                                  id="analytics-revenue-chart">
                                                
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                            </div>
                        </div>
                    </div>

                    <div class="hp-flex-none w-auto hp-dashboard-line px-0 col">
                        <div class="hp-bg-black-40 hp-bg-dark-80 h-100 mx-24" style="width: 1px;"></div>
                    </div>

                    <div class="col hp-analytics-col-2">
                        <div class="row g-32">
                        <div class="col-12">
                                <div class="card hp-card-2">
                                    <div class="card-body px-16">
                                        <div class="row justify-content-between mb-8">
                                            <div class="col">
                                                <div class="d-flex align-items-center">
                                                    <h5 class="me-8 mb-0">Target for <b><?php echo date('Y');?> </b> </h5>
                                                </div>
                                            </div>

                                            <div class="col-6 hp-flex-none w-auto">
                                                
                                            </div>
                                        </div>

                                        <div class="row align-items-center g-16">
                                            <div class="col-12">
                                                <p class="hp-badge-text mb-0 text-black-80 hp-text-color-dark-30">
                                                The milestone earning you set to achieve
                                                </p>

                                                <h2><?= $currency ?>  <?= money($target) ?>  </h2>

                                                <div class="d-flex align-items-center">
                                                    <i class="ri-arrow-right-up-line text-primary" style="font-size: 30px;"></i>
                                                    <p class="mb-0  text-primary">
                                                    <?php
                                                    $percentagesales = ($yearBalance / $target)  * 100;
                                                    echo round($percentagesales, 2). "% Achieved";

                                                    ?>
                                                    </p>
                                                </div>
                                            </div>

                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card hp-card-6">
                                        <div class="card-body pb-0">
                                    <div class="col-12">
                                <span class="h3 d-block fw-semibold hp-text-color-black-bg hp-text-color-dark-0 mb-0">This Month </span>
                                <p class="hp-badge-text text-black-80 hp-text-color-dark-30 mb-0"><?php echo date('F, Y');?> Transactions</p>

                                <div class="row mt-24">
                                    <div class="hp-cursor-pointer hp-transition hp-hover-bg-dark-100 hp-hover-bg-black-10 rounded py-8 mb-16 col-12">
                                        <div class="row align-items-end justify-content-between">
                                            <div class="col">
                                                <div class="row align-items-center">
                                                    <div class="hp-flex-none w-auto pe-0 col">
                                                        
                                                    </div>

                                                    <div class="hp-flex-none w-auto ps-0 col">
                                                        <span class="d-block hp-p3-body fw-medium hp-text-color-black-bg hp-text-color-dark-0"> Income </span>
                                                        <span class="d-block hp-caption fw-normal hp-text-color-black-60">Payment Received</span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="hp-flex-none w-auto col">
                                                <span class="h6 hp-text-color-black-bg hp-text-color-dark-0"><?= $currency ?> <?= money($monthIncome) ?></span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="hp-cursor-pointer hp-transition hp-hover-bg-dark-100 hp-hover-bg-black-10 rounded py-8 mb-16 col-12">
                                        <div class="row align-items-end justify-content-between">
                                            <div class="col">
                                                <div class="row align-items-center">
                                                    <div class="hp-flex-none w-auto pe-0 col">
                                                       
                                                    </div>

                                                    <div class="hp-flex-none w-auto ps-0 col">
                                                        <span class="d-block hp-p1-body fw-medium hp-text-color-black-bg hp-text-color-dark-0">  Expenditure </span>
                                                        <span class="d-block hp-caption fw-normal hp-text-color-black-60">Your Expenses</span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="hp-flex-none w-auto col">
                                                <span class="h6 hp-text-color-black-bg hp-text-color-dark-0"><?= $currency ?>  <?= money($monthExpense) ?></span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="hp-cursor-pointer hp-transition hp-hover-bg-dark-100 hp-hover-bg-black-10 rounded py-8 mb-16 col-12">
                                        <div class="row align-items-end justify-content-between">
                                            <div class="col">
                                                <div class="row align-items-center">
                                                    <div class="hp-flex-none w-auto pe-0 col">
                                                        
                                                    </div>

                                                    <div class="hp-flex-none w-auto ps-0 col">
                                                        <span class="d-block hp-p1-body fw-medium hp-text-color-black-bg hp-text-color-dark-0"> Earnings </span>
                                                        <span class="d-block hp-caption fw-normal hp-text-color-black-60"> Total Profit </span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="hp-flex-none w-auto col">
                                                <span class="h6 hp-text-color-black-bg hp-text-color-dark-0"><?= $currency ?> <?= money($monthBalance) ?></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="hp-cursor-pointer hp-transition hp-hover-bg-dark-100 hp-hover-bg-black-10 rounded py-8 mb-16 col-12">
                                        <div class="row align-items-end justify-content-between">
                                            <div class="col">
                                                <div class="row align-items-center">
                                                    <div class="hp-flex-none w-auto pe-0 col">
                                                        
                                                    </div>

                                                    <div class="hp-flex-none w-auto ps-0 col">
                                                        <span class="d-block hp-p1-body fw-medium hp-text-color-black-bg hp-text-color-dark-0"> Target </span>
                                                        <span class="d-block hp-caption fw-normal hp-text-color-black-60">Monthly Target </span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="hp-flex-none w-auto col">
                                                <span class="h6 hp-text-color-black-bg hp-text-color-dark-0">
                
                                            <?= $currency?>  <?= money(($target / 12), 2);  ?></span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="hp-cursor-pointer hp-transition hp-hover-bg-dark-100 hp-hover-bg-black-10 rounded py-8 mb-16 col-12">
                                        <div class="row align-items-end justify-content-between">
                                            <div class="col">
                                                <div class="row align-items-center">
                                                    <div class="hp-flex-none w-auto pe-0 col">
                                                        
                                                    </div>

                                                    <div class="hp-flex-none w-auto ps-0 col">
                                                        <span class="d-block hp-p1-body fw-medium hp-text-color-black-bg hp-text-color-dark-0">Achievement</span>
                                                        <span class="d-block hp-caption fw-normal hp-text-color-black-60">Month's Milestone </span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="hp-flex-none w-auto col">
                                                <span class="h6 hp-text-color-black-bg hp-text-color-dark-0">                
                                                    <?php
                                                    $percentagesales = ($monthBalance / ($target / 12))  * 100;
                                                    echo round($percentagesales, 2). "% ";

                                                    ?></span>
                                            </div>
                                        </div>
                                    </div>



                                    
                                    
                                </div>
   
                            </div>



                            


                            </div>
                            
                            </div>



                            <div class="card hp-card-5">
                                        <div class="card-body pb-0">
                                    <div class="col-12">
                                <span class="h3 d-block fw-semibold hp-text-color-black-bg hp-text-color-dark-0 mb-0">Invoicing this Month </span>
                                <p class="hp-badge-text text-black-80 hp-text-color-dark-30 mb-0"><?php echo date('F, Y');?> </p>

                                <div class="row mt-24">
                                    <div class="hp-cursor-pointer hp-transition hp-hover-bg-dark-100 hp-hover-bg-black-10 rounded py-8 mb-16 col-12">
                                        <div class="row align-items-end justify-content-between">
                                            <div class="col">
                                                <div class="row align-items-center">
                                                    <div class="hp-flex-none w-auto pe-0 col">
                                                        
                                                    </div>

                                                    <div class="hp-flex-none w-auto ps-0 col">
                                                        <span class="d-block hp-p3-body fw-medium hp-text-color-black-bg hp-text-color-dark-0">Invoices Created </span>
                                                        <span class="d-block hp-caption fw-normal hp-text-color-black-60">Total created Invoices</span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="hp-flex-none w-auto col">
                                                <span class="h6 hp-text-color-black-bg hp-text-color-dark-0"><?= $currency ?> <?= money($totalAmount) ?></span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="hp-cursor-pointer hp-transition hp-hover-bg-dark-100 hp-hover-bg-black-10 rounded py-8 mb-16 col-12">
                                        <div class="row align-items-end justify-content-between">
                                            <div class="col">
                                                <div class="row align-items-center">
                                                    <div class="hp-flex-none w-auto pe-0 col">
                                                       
                                                    </div>

                                                    <div class="hp-flex-none w-auto ps-0 col">
                                                        <span class="d-block hp-p1-body fw-medium hp-text-color-black-bg hp-text-color-dark-0"> Paid Invoices </span>
                                                        <span class="d-block hp-caption fw-normal hp-text-color-black-60">Total Paid Invoices</span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="hp-flex-none w-auto col">
                                                <span class="h6 hp-text-color-black-bg hp-text-color-dark-0"><?= $currency ?>  <?= money($paidAmount) ?></span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="hp-cursor-pointer hp-transition hp-hover-bg-dark-100 hp-hover-bg-black-10 rounded py-8 mb-16 col-12">
                                        <div class="row align-items-end justify-content-between">
                                            <div class="col">
                                                <div class="row align-items-center">
                                                    <div class="hp-flex-none w-auto pe-0 col">
                                                        
                                                    </div>

                                                    <div class="hp-flex-none w-auto ps-0 col">
                                                        <span class="d-block hp-p1-body fw-medium hp-text-color-black-bg hp-text-color-dark-0">Pending Invoices </span>
                                                        <span class="d-block hp-caption fw-normal hp-text-color-black-60"> Total Pending Invoices </span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="hp-flex-none w-auto col">
                                                <span class="h6 hp-text-color-black-bg hp-text-color-dark-0"><?= $currency ?> <?= money($pendingAmount) ?></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="hp-cursor-pointer hp-transition hp-hover-bg-dark-100 hp-hover-bg-black-10 rounded py-8 mb-16 col-12">
                                        <div class="row align-items-end justify-content-between">
                                            <div class="col">
                                                <div class="row align-items-center">
                                                    <div class="hp-flex-none w-auto pe-0 col">
                                                        
                                                    </div>

                                                    <div class="hp-flex-none w-auto ps-0 col">
                                                        <span class="d-block hp-p1-body fw-medium hp-text-color-black-bg hp-text-color-dark-0"> Active Customer </span>
                                                        <span class="d-block hp-caption fw-normal hp-text-color-black-60">Active Customer count </span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="hp-flex-none w-auto col">
                                                <span class="h6 hp-text-color-black-bg hp-text-color-dark-0">
                
                                            <?php 
                
                                                    $sql = "SELECT * FROM store_customers";
                                                    $query = $mysqli->query($sql);

                                                    echo "$query->num_rows";
                                                    ?></span>
                                            </div>
                                        </div>
                                    </div>

                                         
                                </div>



                            </div>


                            </div>
                            
                            </div>
                            <!--All time -->
<div style="margin-top: 60px" class="col-12">
                                        <div class="card hp-card-4">
                                            <div class="card-body">
                                                <div class="row">
                                                    <div class="col-12">
                                                        <div class="row align-items-start justify-content-between">
                                                            <h5 class="mb-24">All time Transactions</h5>
                                                        </div>
                                                    </div>

                                                    <div class="col-12">
                                                        <div class="row g-16 justify-content-between hp-bestSellingCategories">
                                                            <div class="col-12">
                                                                <div class="row align-items-center justify-content-between">
                                                                    <div class="col hp-flex-none w-auto">
                                                                        <div class="row g-8 align-items-center">
                                                                            <div class="col hp-flex-none w-auto">
                                                                                <div class="bg-black-20 hp-bg-color-dark-70 p-4 rounded text-center" style="width: 48px; height: 48px;">
                                                                                    <img src="images/icon/wallet.png" alt="Technology">
                                                                                </div>
                                                                            </div>

                                                                            <div class="col hp-flex-none w-auto">
                                                                                <p class="mb-4 text-black-100 hp-text-color-dark-0 hp-badge-text fw-medium">Income</p>
                                                                                <p class="mb-0 text-black-80 hp-text-color-dark-30 hp-input-description">All time Income</p>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <div class="col hp-flex-none w-auto">
                                                                        <p class="mb-4 hp-p1-body">
                                                                        <?= $currency ?><?= money($income) ?>
                </p>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="col-12">
                                                                <div class="row align-items-center justify-content-between">
                                                                    <div class="col hp-flex-none w-auto">
                                                                        <div class="row g-8 align-items-center">
                                                                            <div class="col hp-flex-none w-auto">
                                                                                <div class="bg-black-20 hp-bg-color-dark-70 p-4 rounded text-center" style="width: 48px; height: 48px;">
                                                                                    <img src="images/icon/expenses.png" alt="Music">
                                                                                </div>
                                                                            </div>

                                                                            <div class="col hp-flex-none w-auto">
                                                                                <p class="mb-4 text-black-100 hp-text-color-dark-0 hp-badge-text fw-medium">Expenditure</p>
                                                                                <p class="mb-0 text-black-80 hp-text-color-dark-30 hp-input-description">All time Expenses</p>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <div class="col hp-flex-none w-auto">
                                                                        <p class="mb-4 hp-p1-body">
                                                                            <?= $currency ?><?= money($expense) ?>
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="col-12">
                                                                <div class="row align-items-center justify-content-between">
                                                                    <div class="col hp-flex-none w-auto">
                                                                        <div class="row g-8 align-items-center">
                                                                            <div class="col hp-flex-none w-auto">
                                                                                <div class="bg-black-20 hp-bg-color-dark-70 p-4 rounded text-center" style="width: 48px; height: 48px;">
                                                                                    <img src="images/icon/wallet.png" alt="Gaming">
                                                                                </div>
                                                                            </div>

                                                                            <div class="col hp-flex-none w-auto">
                                                                                <p class="mb-4 text-black-100 hp-text-color-dark-0 hp-badge-text fw-medium">Earnings</p>
                                                                                <p class="mb-0 text-black-80 hp-text-color-dark-30 hp-input-description">All time Profit</p>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <div class="col hp-flex-none w-auto">
                                                                        <p class="mb-4 hp-p1-body">
                                                                        <?= $currency ?><?= money($balance) ?>
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                                                                                        <div class="col-12">
                                                                <div class="row align-items-center justify-content-between">
                                                                    <div class="col hp-flex-none w-auto">
                                                                        <div class="row g-8 align-items-center">
                                                                            <div class="col hp-flex-none w-auto">
                                                                                <div class="bg-black-20 hp-bg-color-dark-70 p-4 rounded text-center" style="width: 48px; height: 48px;">
                                                                                    <img src="images/icon/wallet.png" alt="Gaming">
                                                                                </div>
                                                                            </div>

                                                                            <div class="col hp-flex-none w-auto">
                                                                                <p class="mb-4 text-black-100 hp-text-color-dark-0 hp-badge-text fw-medium">Paid Invoices</p>
                                                                                <p class="mb-0 text-black-80 hp-text-color-dark-30 hp-input-description">All time Paid Invoices</p>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <div class="col hp-flex-none w-auto">
                                                                        <p class="mb-4 hp-p1-body">
                                                                        <?= $currency ?><?= money($paid1) ?>
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="col-12">
                                                                <div class="row align-items-center justify-content-between">
                                                                    <div class="col hp-flex-none w-auto">
                                                                        <div class="row g-8 align-items-center">
                                                                            <div class="col hp-flex-none w-auto">
                                                                                <div class="bg-black-20 hp-bg-color-dark-70 p-4 rounded text-center" style="width: 48px; height: 48px;">
                                                                                <img src="images/icon/transactions.png" alt="">
                                                                                </div>
                                                                            </div>

                                                                            <div class="col hp-flex-none w-auto">
                                                                                <p class="mb-4 text-black-100 hp-text-color-dark-0 hp-badge-text fw-medium">Pending Invoices</p>
                                                                                <p class="mb-0 text-black-80 hp-text-color-dark-30 hp-input-description">All time invoices</p>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <div class="col hp-flex-none w-auto">
                                                                        <p class="mb-4 hp-p1-body">
                                                                            <?= $currency ?><?= money($pending1) ?>
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                            
                              </div>
                            </div>
<!-- all time transactions -->                              


<!--new tab -->
<style>
.table thead tr th {
    padding: 3px 8px;     /* controls height */
    line-height: 2;
    height: 5px; 
    
}

</style>    

                        <div class="">
                            <div class="col-12">
                                <div class="row g-32">
                                    <div class="col-12 col-xl-4">
                                        <div class="card hp-card-6 hp-chart-text-color">
                                            <div class="card-body">
                                                
                                                <div class="d-flex align-items-center justify-content-between mb-32">
            <h5 class="mb-0">Latest Invoices</h5>
            <a href="invoice-list.php" class="hp-p1-body mb-0 fw-medium text-black-100 hp-text-color-dark-0">View all</a>
            </div>
                        <div style="margin-top: -10px;" class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead style="background: #aef5d9ff;">
                                    <tr>
                                        <th style="width: 10%;">
                                            <span class="hp-badge-size d-block pb-16 fw-bold text-black-80 hp-text-color-dark-100 text-uppercase">Date</span>
                                        </th>
                                        <th style="width: 14%;">
                                            <span class="hp-badge-size d-block pb-16 fw-bold text-black-80 hp-text-color-dark-50 text-uppercase">Inv.no</span>
                                        </th>
                                        <th style="width: ">
                                            <span class="hp-badge-size d-block pb-16 fw-bold text-black-80 hp-text-color-dark-50 text-uppercase"> Name</span>
                                        </th>
                                        <th>
                                            <span class="hp-badge-size d-block pb-16 fw-bold text-black-80 hp-text-color-dark-50 text-uppercase">Type</span>
                                        </th>
                                        <th>
                                            <span class="hp-badge-size d-block pb-16 fw-bold text-black-80 hp-text-color-dark-50 text-uppercase">Amount</span>
                                        </th>
                                        
                                        <th class="text-center">
                                            <span class="hp-badge-size d-block pb-16 fw-bold text-black-80 hp-text-color-dark-50 text-uppercase">Status</span>
                                        </th>
                                    </tr>
                                </thead>

                                <tbody>
                                <?php foreach ($latestInvoices as $row): ?>

                                
                                    <tr>
                                    <td class="ps-0">
                                        <span class="mb-0 fw-medium text-black-100 hp-text-color-dark-0"><?= date('d M Y', strtotime($row['invoice_date'])) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['invoice']) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['name']) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['invoice_type']) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= number_format((float) ($row['total'] ?? 0), 2) ?> </span>
                                    </td>
                                    
                                    <td class="text-center">                            <span class="badge 
                                                    <?= $row['status']==='Paid' ? 'bg-success' :
                                                    ($row['status']==='Pending' ? 'bg-danger' : 'bg-warning') ?>">
                                                    <?= $row['status'] ?>
                                                </span>
                                    
                                </td>
                                    
                                
                            

                                </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                    </div>  
            
                                                
                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-12 col-xl-4">
                                        <div class="card hp-card-6 hp-chart-text-color">
                                            <div class="card-body">
                                                <div class="d-flex align-items-center justify-content-between mb-32">
            <h5 class="mb-0">Latest Transactions</h5>
            <a href="expense-list.php" class="hp-p1-body mb-0 fw-medium text-black-100 hp-text-color-dark-0">View all</a>
            </div>
                        <div style="margin-top: -10px;" class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead>
                                    <tr>
                                        <th style="width: 10%;">
                                            <span class="hp-badge-size d-block pb-16 fw-bold text-black-80 hp-text-color-dark-50 text-uppercase">Date</span>
                                        </th>
                                        <th style="width: 14%;">
                                            <span class="hp-badge-size d-block pb-16 fw-bold text-black-80 hp-text-color-dark-50 text-uppercase">ID</span>
                                        </th>
                                        <th style="width: ">
                                            <span class="hp-badge-size d-block pb-16 fw-bold text-black-80 hp-text-color-dark-50 text-uppercase"> Type</span>
                                        </th>
                                        <th>
                                            <span class="hp-badge-size d-block pb-16 fw-bold text-black-80 hp-text-color-dark-50 text-uppercase">Description</span>
                                        </th>
                                        <th>
                                            <span class="hp-badge-size d-block pb-16 fw-bold text-black-80 hp-text-color-dark-50 text-uppercase">Amount</span>
                                        </th>
                                        
                                        <th class="text-center">
                                            <span class="hp-badge-size d-block pb-16 fw-bold text-black-80 hp-text-color-dark-50 text-uppercase">Status</span>
                                        </th>
                                    </tr>
                                </thead>

                                <tbody>
                                <?php foreach ($latestTransactions as $row): ?>

                                
                                    <tr>
                                    <td class="ps-0">
                                        <span class="mb-0 fw-medium text-black-100 hp-text-color-dark-0"><?= date('d M Y', strtotime($row['expense_date'])) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['expense_id']) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['transaction_type']) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['expense_desc']) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= number_format((float) ($row['expense_amount'] ?? 0), 2) ?> </span>
                                    </td>
                                    
                                    <td class="text-center">                            <span class="badge 
                                                    <?= $row['transaction_status']==='completed' ? 'bg-success' :
                                                    ($row['transaction_status']==='pending' ? 'bg-danger' : 'bg-warning') ?>">
                                                    <?= $row['transaction_status'] ?>
                                                </span>
                                    
                                </td>
                                    
                                
                            

                                </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                    </div>  
            
                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-12 col-xl-4">
                                        <div class="card hp-card-6 hp-chart-text-color">
                                            <div class="card-body">
                                                <div class="d-flex align-items-center justify-content-between mb-32">
            <h5 class="mb-0">Latest Vouchers</h5>
            <a href="voucher-list.php" class="hp-p1-body mb-0 fw-medium text-black-100 hp-text-color-dark-0">View all</a>
            </div>
                        <div style="margin-top: -10px;" class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead>
                                    <tr>
                                        <th style="width: 10%;">
                                            <span class="hp-badge-size d-block pb-16 fw-bold text-black-80 hp-text-color-dark-50 text-uppercase">Date</span>
                                        </th>
                                        <th style="width: 10%;">
                                            <span class="hp-badge-size d-block pb-16 fw-bold text-black-80 hp-text-color-dark-50 text-uppercase">Ref.no</span>
                                        </th>
                                        <th style="width: 25% ">
                                            <span class="hp-badge-size d-block pb-16 fw-bold text-black-80 hp-text-color-dark-50 text-uppercase"> Title</span>
                                        </th>
                                        <th style="width: 15% " >
                                            <span class="hp-badge-size d-block pb-16 fw-bold text-black-80 hp-text-color-dark-50 text-uppercase">Req.By</span>
                                        </th>
                                        <th>
                                            <span class="hp-badge-size d-block pb-16 fw-bold text-black-80 hp-text-color-dark-50 text-uppercase">Amount</span>
                                        </th>
                                        
                                        <th class="text-center">
                                            <span class="hp-badge-size d-block pb-16 fw-bold text-black-80 hp-text-color-dark-50 text-uppercase">Mode</span>
                                        </th>
                                    </tr>
                                </thead>

                                <tbody>
                                <?php foreach ($latestVouchers as $row): ?>

                                
                                    <tr>
                                    <td class="ps-0">
                                        <span class="mb-0 fw-medium text-black-100 hp-text-color-dark-0"><?= date('d M Y', strtotime($row['voucher_date'])) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['voucher_id']) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['short_title']) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['requested_by']) ?></span>
                                    </td>
                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= number_format((float) ($row['total'] ?? 0), 2) ?> </span>
                                    </td>

                                    <td>
                                        <span class="mb-0 text-black-80 hp-text-color-dark-30"><?= htmlspecialchars($row['payment_mode']) ?></span>
                                    </td>
                                    
                                    
                                    
                                
                            

                                </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                    </div>  
            

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                            






<!--all time -->
                            
                      
                
            

    <?php include ('footer.php'); ?>     
    <!-- Plugin -->
    <script src="app-assets/js/plugin/jquery.min.js"></script>
    <script src="app-assets/js/plugin/bootstrap.bundle.min.js"></script>
    <script src="app-assets/js/plugin/swiper-bundle.min.js"></script>
    <script src="app-assets/js/plugin/jquery.mask.min.js"></script>
    <script src="app-assets/js/plugin/autocomplete.min.js"></script>
    <script src="app-assets/js/plugin/moment.min.js"></script>

    <!-- Layouts -->
    <script src="app-assets/js/layouts/header-search.js"></script>
    <script src="app-assets/js/layouts/sider.js"></script>
    <script src="app-assets/js/components/input-number.js"></script>

    <!-- Base -->
    <script src="app-assets/js/base/index.js"></script>
    <!-- Customizer -->
    <script src="app-assets/js/customizer.js"></script>

    <!-- Charts -->
    <script src="app-assets/js/plugin/apexcharts.min.js"></script>
    <script src="app-assets/js/charts/apex-chart.js"></script>

    <!-- Cards -->
    <script src="app-assets/js/cards/card-analytic.js"></script>
    <script src="app-assets/js/cards/card-advance.js"></script>
    <script src="app-assets/js/cards/card-statistic.js"></script>

    <!-- Custom -->
    <script src="assets/js/main.js"></script>






<script>
const monthlyBalances = <?= json_encode($monthlyBalances, JSON_NUMERIC_CHECK) ?>;

// Dashboard Analytics – Earnings (Balance)
let optionsAnalyticsBalanceChart = {
    series: [
        {
            name: "Earnings",
            data: monthlyBalances
        }
    ],

    fill: {
        opacity: 1,
        colors: [
            document.body.classList.contains("dark") ? "#ffffff" : "#2D3436"
        ]
    },

    chart: {
        id: "dashboard-analytics-balance-chart",
        fontFamily: "Manrope, sans-serif",
        type: "bar",
        height: 350,
        toolbar: { show: false },
        zoom: { enabled: false }
    },

    dataLabels: { enabled: false },

    grid: {
        borderColor: "#B2BEC3"
    },

    plotOptions: {
        bar: {
            horizontal: false,
            borderRadius: 4,
            columnWidth: "55%",
            colors: {
                backgroundBarColors: ["#B2BEC3"],
                backgroundBarOpacity: 0.2
            }
        }
    },

    stroke: {
        show: true,
        width: 3,
        colors: ["transparent"]
    },

    xaxis: {
        categories: [
            "Jan","Feb","Mar","Apr","May","Jun",
            "Jul","Aug","Sep","Oct","Nov","Dec"
        ],
        labels: {
            style: {
                colors: "#636E72",
                fontSize: "12px"
            }
        }
    },

    yaxis: {
        labels: {
            formatter: value => value.toLocaleString(),
            style: {
                colors: "#636E72",
                fontSize: "13px"
            }
        }
    },

    legend: {
        position: "top",
        horizontalAlign: "right"
    }
};

if (document.querySelector("#dashboard-analytics-balance-chart")) {
    new ApexCharts(
        document.querySelector("#dashboard-analytics-balance-chart"),
        optionsAnalyticsBalanceChart
    ).render();
}
</script>


<!--Invoice -->

                <script>
            const chartTotal   = <?= json_encode($chartTotal, JSON_NUMERIC_CHECK) ?>;
            const chartPaid    = <?= json_encode($chartPaid, JSON_NUMERIC_CHECK) ?>;
            const chartPending = <?= json_encode($chartPending, JSON_NUMERIC_CHECK) ?>;
            </script>

    <script type="text/javascript">
// Analytics Revenue 1
const optionsAnalyticsRevenue1 = {
    series: [
        {
            name: "Total Bills",
            data: chartTotal
        },
        {
            name: "Paid Bills",
            data: chartPaid
        },
        {
            name: "Pending Bills",
            data: chartPending
        }
    ],

    chart: {
        type: "bar",
        height: 320,
        fontFamily: "Manrope, sans-serif",
        toolbar: { show: false }
    },

    dataLabels: { enabled: false },

    plotOptions: {
        bar: {
            horizontal: false,
            columnWidth: "60%",
            borderRadius: 4
        }
    },

    colors: ["#2563eb", "#16a34a", "#dc2626"],

    stroke: {
        show: true,
        width: 3,
        colors: ["transparent"]
    },

    xaxis: {
        categories: [
            "Jan","Feb","Mar","Apr","May","Jun",
            "Jul","Aug","Sep","Oct","Nov","Dec"
        ],
        labels: {
            style: { fontSize: "13px" }
        }
    },

    yaxis: {
        labels: {
            formatter: (val) => "₦" + val.toLocaleString()
        }
    },

    legend: {
        position: "top",
        horizontalAlign: "right"
    },

    grid: {
        borderColor: "#e5e7eb"
    }
};

if (document.querySelector("#analytics-revenue-chart")) {
    const chart = new ApexCharts(
        document.querySelector("#analytics-revenue-chart"),
        optionsAnalyticsRevenue1
    );
    chart.render();
}


</script>



</body>



</html>