<?php
require('nav.php');

session_start();
require_once '../includes/config.php';

// Ensure company context
if (!isset($_SESSION['company_id'])) {
    echo "
        <script>
            alert('Company context missing. Please re-login.');
            window.location.href = '../sign-in.php';
        </script>
        ";
    exit;
}

$company_id = (int) $_SESSION['company_id'];


?>

<div style="margin-top: 20px;" class="hp-main-layout-content">

<div class="page-header-modern d-flex align-items-center justify-content-between">
    
    <!-- LEFT: Page title -->
    <h2 class="header-modern">Users List</h2>

    <!-- RIGHT: User dropdown -->
    <div class="dropdown">
        <button
            class="btn btn-user dropdown-toggle"
            type="button"
            id="userDropdown"
            data-bs-toggle="dropdown"
            aria-expanded="false"
        >
            <i class=""></i>
            <span class="user-name capitalize">
                <img src="../images/icon/invoice360-user.png" height=30px; width=30px;>
            </span>
        </button>

        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
            <li>
                <a class="dropdown-item" href="">
                    <i class="fa fa-user me-2"></i>   <?php echo strtok($_SESSION['user_name'], ' ');?> (<?php echo $_SESSION['role']; ?>)
                </a>
            </li>

            <li>
                <a class="dropdown-item" href="payment-details.php">
                    <i class="fa fa-credit-card"></i> Billing history
                </a>
            </li>

            <li>
                <a class="dropdown-item" href="company-profile.php">
                    <i class="fa fa-cog me-2"></i> Settings
                </a>
            </li>

            <li><hr class="dropdown-divider"></li>

            <li>
                <a class="dropdown-item text-danger" href="logout.php">
                    <i class="fa fa-sign-out me-2"></i> Sign Out
                </a>
            </li>
        </ul>
    </div>

</div>

                <style>
        @import url('https://fonts.googleapis.com/css?family=Montserrat:400,500,600,700|Poppins:400,500&display=swap');

        * {
            margin: 0;
            font-family: 'Poppins', sans-serif;
            padding: 0;
            box-sizing: border-box;
        }

        nav {
            position: absolute !important;
            top: 0;
            width: 100%;
            z-index: 5;
        }

        
       

        #deleteBtn {
            font-size: 15px;
            width: 25px;
            color: #fff;
            background-color: #AA4A44;
            border: none;
            
        }

        table td {
  border-left: 1px solid #000;  /* vertical border */
  border-right: 1px solid #000; /* vertical border */
  padding: 8px; /* spacing inside cells */
}
    </style>
</head>


<body>


    <div style="margin-bottom: 15px" class="d-flex justify-content-end mb-3">

        <a style="margin-right: 3px;" href="user-add.php" class="btn btn-secondary btn-sm me-2">
            <i class="fa fa-plus-circle"> </i>New User
        </a>


    </div>

    <div style="margin-top: -20px;"class="">
        <div class="content">
            
            <div class="table-responsive">
            <table class="table table-striped table-hover no-border" id="data-table">
    <thead>
        <tr>
            <th width="7%">#</th>
            <th width="20%">Name</th>
            <th width="20%">Email</th>
            <th width="20%">Password</th>
            <th width="11%">Date Added</th>
            <th width="10%">Role</th>
            <th width="20%">Action</th>
        </tr>
    </thead>
    <tbody>

<?php
$stmt = $conn->prepare("
    SELECT id, name, email, password, created_at, role
    FROM users
    WHERE company_id = ?
    ORDER BY id DESC
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$result = $stmt->get_result();

$sn = 1;

while ($row = $result->fetch_assoc()):
?>
    <tr>
        <td><?= $sn ?></td>

        <td id="name-<?= $row['id'] ?>">
            <?= htmlspecialchars($row['name']) ?>
        </td>

        <td id="username-<?= $row['id'] ?>">
            <?= htmlspecialchars($row['email']) ?>
        </td>

        <td>********</td>

        <td id="createdDate-<?= $row['id'] ?>">
            <?= htmlspecialchars($row['created_at']) ?>
        </td>

        <td id="role-<?= $row['id'] ?>">
            <?= htmlspecialchars($row['role']) ?>
        </td>

        <td>
            <a href="user-edit.php?id=<?= $row['id'] ?>" 
               class="btn btn-primary btn-xs">
                <span class="fa fa-edit"></span>
            </a>

            <button onclick="delete_user(<?= $row['id'] ?>)" 
                    class="btn btn-danger btn-xs">
                <span class="fa fa-trash"></span>
            </button>
        </td>
    </tr>
<?php
    $sn++;
endwhile;

$stmt->close();
?>
    </tbody>
</table>
              </div>
        </div>
        </div>
    </div>

    <script>
        function delete_user(id) {
            if (confirm("Do you want to delete this user?")) {
                window.location = "endpoint/delete-user.php?user=" + id;
            }
        }
    </script>

   


             

 <!-- Plugin -->
 
    <!-- Plugin -->
    <script data-cfasync="false" src="../../../../../cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
    <script src="../app-assets/js/plugin/jquery.min.js"></script>
    <script src="../app-assets/js/plugin/bootstrap.bundle.min.js"></script>
    <script src="../app-assets/js/plugin/swiper-bundle.min.js"></script>
    <script src="../app-assets/js/plugin/jquery.mask.min.js"></script>
    <script src="../app-assets/js/plugin/autocomplete.min.js"></script>
    <script src="../app-assets/js/plugin/moment.min.js"></script>

    <!-- Layouts -->
    <script src="../app-assets/js/layouts/header-search.js"></script>
    <script src="../app-assets/js/layouts/sider.js"></script>
    <script src="../app-assets/js/components/input-number.js"></script>

    <!-- Base -->
    <script src="../app-assets/js/base/index.js"></script>
    <!-- Customizer -->
    <script src="../app-assets/js/customizer.js"></script>

    <!-- Custom -->
    <script src="../assets/js/main.js"></script>
</body>


</html>