<?php

require('../session-master.php');
require_once "../includes/config.php";

require '../PDFvendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

/* =========================
   VALIDATE INPUT
========================= */
if (!isset($_GET['id'])) {
    echo "
        <script>
            alert('Invalid Receipt Request');
            window.location.href = 'overview.php';
        </script>
        ";
    exit;
}

$subscription_id = (int) $_GET['id'];
$company_id      = (int) $_SESSION['company_id'];

/* =========================
   FETCH RECEIPT DATA
========================= */
$stmt = $conn->prepare("
    SELECT
        s.id,
        s.plan,
        s.status,
        s.amount,
        s.started_at,
        s.ends_at,
        s.created_at,
        c.company_name
    FROM subscriptions s
    JOIN company c ON c.id = s.company_id
    WHERE s.id = ? AND s.company_id = ?
    LIMIT 1
");
$stmt->bind_param("ii", $subscription_id, $company_id);
$stmt->execute();
$data = $stmt->get_result()->fetch_assoc();

if (!$data) {
    echo "
        <script>
            alert('Not Found');
            window.location.href = 'overview.php';
        </script>
        ";
    exit;
}

/* =========================
   FORMAT VALUES
========================= */
$amount     = number_format($data['amount'], 2);
$invoiceNo  = "INV-" . str_pad($data['id'], 6, "0", STR_PAD_LEFT);
$paidOn     = date("d M Y", strtotime($data['created_at']));
$started    = date("d M Y", strtotime($data['started_at']));
$expires    = date("d M Y", strtotime($data['ends_at']));
$plan       = ucfirst($data['plan']);
$status     = ucfirst($data['status']);

/* =========================
   RECEIPT HTML
========================= */
$html = "
<!DOCTYPE html>
<html>
<head>
<style>
body {
    font-family: DejaVu Sans, sans-serif;
    font-size: 12px;
    color: #333;
}
.header {
    text-align: center;
    margin-bottom: 30px;
}
.header h2 {
    margin: 0;
}
.details, .summary {
    width: 100%;
    margin-bottom: 20px;
}
.details td {
    padding: 5px 0;
}
.table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 20px;
}
.table th, .table td {
    border: 1px solid #ddd;
    padding: 10px;
}
.table th {
    background: #f5f7fa;
}
.total {
    text-align: right;
    margin-top: 20px;
    font-size: 14px;
    font-weight: bold;
}
.footer {
    text-align: center;
    margin-top: 40px;
    font-size: 11px;
    color: #777;
}
</style>
</head>

<body>

<div class='header'>
    <h2>invoice360.</h2>
    <p>Payment Receipt</p>
</div>

<table class='details'>
<tr>
    <td><strong>Company:</strong> {$data['company_name']}</td>
    <td align='right'><strong>Paid On:</strong> {$paidOn}</td>
</tr>
<tr>
    <td><strong>Invoice:</strong> {$invoiceNo}</td>
    <td align='right'><strong>Paid On:</strong> {$paidOn}</td>
</tr>
<tr>
    <td><strong>Plan:</strong> {$plan}</td>
    <td align='right'><strong>Status:</strong> {$status}</td>
</tr>
<tr>
    <td><strong>Start Date:</strong> {$started}</td>
    <td align='right'><strong>Expiry Date:</strong> {$expires}</td>
</tr>
</table>

<table class='table'>
<thead>
<tr>
    <th>Description</th>
    <th align='right'>Amount</th>
</tr>
</thead>
<tbody>
<tr>
    <td>{$plan} Subscription</td>
    <td align='right'>₦{$amount}</td>
</tr>
</tbody>
</table>

<div class='total'>
Total Paid: ₦{$amount}
</div>

<div class='footer'>
    This receipt was generated electronically and does not require a signature.
</div>

</body>
</html>
";

/* =========================
   GENERATE PDF
========================= */
$options = new Options();
$options->set('defaultFont', 'DejaVu Sans');

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

/* =========================
   STREAM TO BROWSER
========================= */
$dompdf->stream($invoiceNo . ".pdf", [
    "Attachment" => false
]);
exit;
