<?php
include('nav.php');

 

?> 
                                                
<?php

/* =========================
   AUTH & CONTEXT
========================= */
$company_id = (int) $_SESSION['company_id'];

/* =========================
   FETCH COMPANY
========================= */
$stmt = $conn->prepare("
    SELECT company_name
    FROM company
    WHERE id = ?
    LIMIT 1
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$company = $stmt->get_result()->fetch_assoc();

/* =========================
   FETCH ALL TRANSACTIONS
========================= */
$stmt = $conn->prepare("
    SELECT
        id,
        plan,
        status,
        amount,
        started_at,
        ends_at,
        created_at
    FROM subscriptions
    WHERE company_id = ?
    ORDER BY created_at DESC
");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$transactions = $stmt->get_result();
?>

<div style="margin-top: 15px" class="hp-main-layout-content">
  <div class="page-header-modern">
            <h2 class="header-modern">Payment History</h2>

        <div class="dropdown">
        <button
            class="btn btn-user dropdown-toggle"
            type="button"
            id="userDropdown"
            data-bs-toggle="dropdown"
            aria-expanded="false"
        >
            <i class=""></i>
            <span class="user-name capitalize">
                <img src="../images/icon/invoice360-user.png" height=30px; width=30px;>
            </span>
        </button>

        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
            <li>
                <a class="dropdown-item" href="">
                    <i class="fa fa-user me-2"></i>   <?php echo strtok($_SESSION['user_name'], ' ');?> (<?php echo $_SESSION['role']; ?>)
                </a>
            </li>

            <li>
                <a class="dropdown-item" href="payment-details.php">
                    <i class="fa fa-credit-card"></i> Billing history
                </a>
            </li>

            <li>
                <a class="dropdown-item" href="company-profile.php">
                    <i class="fa fa-cog me-2"></i> Settings
                </a>
            </li>

            <li><hr class="dropdown-divider"></li>

            <li>
                <a class="dropdown-item text-danger" href="logout.php">
                    <i class="fa fa-sign-out me-2"></i> Sign Out
                </a>
            </li>
        </ul>
    </div>
    </div> 
	
                <div class="row mb-32 gy-32">
                <div class="col-12">
   				
                
    

                    <div class="content-body">
    <div class="container-fluid">
     
    <div id="response" class="alert" style="display:none;">
    <span class="message"></span>
    <span class="response-close">&times;</span>
</div>

        
		<div class="panel panel-default">

    			<div class="panel-body form-group form-group-sm">

<style>
body {
    background: #f5f7fa;
    font-family: "Segoe UI", sans-serif;
}

.card {
    margin: 10px 10px;
    background: #fff;
    border-radius: 10px;
    padding: 25px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.08);
    min-height: 700px; /* adjust as needed */
}

.table th {
    background: #f9fafb;
}

.badge-success { background: #5cb85c; }
.badge-warning { background: #f0ad4e; }
.badge-danger  { background: #d9534f; }
</style>
</head>

<body>

<div class="card">
    <h3><?= htmlspecialchars($company['company_name']) ?> — Transactions</h3>
    <p class="text-muted">All payments ordered by most recent</p>

    <div style="margin-top: -10px;" class="table-responsive">
    <table class="table  table-bordered table-striped">
        <thead>
            <tr>
                <th>s/n</th>
                <th>Plan</th>
                <th>Status</th>
                <th>Amount</th>
                <th>Started</th>
                <th>Expires</th>
                <th>Payment Date</th>
                <th>Receipt</th>
            </tr>
        </thead>
        <tbody>


        <?php if ($transactions->num_rows > 0): ?>
            <?php while ($row = $transactions->fetch_assoc()): ?>

                <?php
                    $statusClass = match ($row['status']) {
                        'active' => 'badge-success',
                        'trial'  => 'badge-warning',
                        default  => 'badge-danger'
                    };

                    $sn = 1;
                ?>

                <tr>
                    
                    <td><?= $sn ?></td>
                    <td><?= ucfirst($row['plan']) ?></td>

                    <td>
                        <span class="badge <?= $statusClass ?>">
                            <?= ucfirst($row['status']) ?>
                        </span>
                    </td>

                    <td>₦<?= number_format($row['amount'], 2) ?></td>
                    <td><?= date("d M Y", strtotime($row['started_at'])) ?></td>
                    <td><?= date("d M Y", strtotime($row['ends_at'])) ?></td>
                    <td><?= date("d M Y", strtotime($row['created_at'])) ?></td>

                                        <td>
                        <a href="payment-receipt-download.php?id=<?= $row['id'] ?>" class="btn btn-xs btn-primary">
                            <span class="glyphicon glyphicon-file"></span>
                            View
                        </a>
                    </td>
                </tr>
                  <?php  $sn++ ?>
            <?php endwhile; ?>
        <?php else: ?>
            <tr>
                <td colspan="7" class="text-center text-muted">
                    No transactions found
                </td>
            </tr>
        <?php endif; ?>

        </tbody>
    </table>
    </div>
</div>
</div></div>




                                                
            <?php include ('footer.php'); ?>     

    <!-- Plugin -->
    <script src="../app-assets/js/plugin/jquery.min.js"></script>
    <script src="../app-assets/js/plugin/bootstrap.bundle.min.js"></script>
    <script src="../app-assets/js/plugin/swiper-bundle.min.js"></script>
    <script src="../app-assets/js/plugin/jquery.mask.min.js"></script>
    <script src="../app-assets/js/plugin/autocomplete.min.js"></script>
    <script src="../app-assets/js/plugin/moment.min.js"></script>

    <!-- Layouts -->
    <script src="../app-assets/js/layouts/header-search.js"></script>
    <script src="../app-assets/js/layouts/sider.js"></script>
    <script src="../app-assets/js/components/input-number.js"></script>

    <!-- Base -->
    <script src="../app-assets/js/base/index.js"></script>
    <!-- Customizer -->
    <script src="../app-assets/js/customizer.js"></script>

    <!-- Charts -->
    <script src="../app-assets/js/plugin/apexcharts.min.js"></script>
    <script src="../app-assets/js/charts/apex-chart.js"></script>

    <!-- Cards -->
    <script src="../app-assets/js/cards/card-advance.js"></script>
    <script src="../app-assets/js/cards/card-analytic.js"></script>
    <script src="../app-assets/js/cards/card-statistic.js"></script>


    <!-- Custom -->
    <script src="../assets/js/main.js"></script>
    






</body>



</html>