<?php
include('nav.php');



$mysqli = new mysqli(DATABASE_HOST, DATABASE_USER, DATABASE_PASS, DATABASE_NAME);

if ($mysqli->connect_error) {
    die("Database Connection Failed: " . $mysqli->connect_error);
}

$stmt = $mysqli->prepare("
    SELECT *
    FROM company
    WHERE id = ?
    LIMIT 1
");

$stmt->bind_param("i", $_SESSION['company_id']);
$stmt->execute();

$result = $stmt->get_result();


// Default values (prevents undefined variable errors)
$company_name = $company_address = $company_town = $company_phone = "";
$company_state = $country = $company_email = "";
$bank_name = $account_no = $account_name = "";
$year_target = $currency = $vat_rate = $terms = "";
$invoice_prefix = $company_logo = "";

// If data exists
if ($row = $result->fetch_assoc()) {

    $company_name    = $row['company_name'] ?? '';
    $company_address = $row['company_address'] ?? '';
    $company_town    = $row['company_town'] ?? '';
    $company_phone   = $row['company_phone'] ?? '';
    $company_state   = $row['company_state'] ?? '';
    $country         = $row['country'] ?? '';
    $company_email   = $row['company_email'] ?? '';

    $bank_name   = $row['bank_name'] ?? '';
    $account_no  = $row['account_no'] ?? '';
    $account_name = $row['account_name'] ?? '';

    $year_target   = $row['year_target'] ?? 0;
    $currency      = $row['currency'] ?? '';
    $enable_vat      = $row['enable_vat'] ?? '';
    $vat_rate      = $row['vat_rate'] ?? '';
    $initial_value_invoice      = $row['initial_value_invoice'] ?? '';
    $initial_value_voucher      = $row['initial_value_voucher'] ?? '';
    $initial_value_transaction      = $row['initial_value_transaction'] ?? '';
    $theme      = $row['theme'] ?? '';
    
    $terms         = $row['terms'] ?? '';
    $invoice_prefix = $row['invoice_prefix'] ?? '';
    $company_logo   = $row['company_logo'] ?? '';
}

// Close connection
$mysqli->close();
?>





<div style="padding-left: 12px; margin-top: 20px;" class="hp-main-layout-content">
    <div class="page-header-modern d-flex align-items-center justify-content-between">
    
    <!-- LEFT: Page title -->
    <h2 class="header-modern">Company Settings</h2>

    <!-- RIGHT: User dropdown -->
    <div class="dropdown">
        <button
            class="btn btn-user dropdown-toggle"
            type="button"
            id="userDropdown"
            data-bs-toggle="dropdown"
            aria-expanded="false"
        >
            <i class=""></i>
            <span class="user-name capitalize">
                <img src="../images/icon/invoice360-user.png" height=30px; width=30px;>
            </span>
        </button>

        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
            <li>
                <a class="dropdown-item" href="">
                    <i class="fa fa-user me-2"></i>   <?php echo strtok($_SESSION['user_name'], ' ');?> (<?php echo $_SESSION['role']; ?>)
                </a>
            </li>

            <li>
                <a class="dropdown-item" href="payment-details.php">
                    <i class="fa fa-credit-card"></i> Billing history
                </a>
            </li>

            <li>
                <a class="dropdown-item" href="company-profile.php">
                    <i class="fa fa-cog me-2"></i> Settings
                </a>
            </li>

            <li><hr class="dropdown-divider"></li>

            <li>
                <a class="dropdown-item text-danger" href="logout.php">
                    <i class="fa fa-sign-out me-2"></i> Sign Out
                </a>
            </li>
        </ul>
    </div>

</div>

                <div class="row mb-32 gy-32">
                    

                    <div class="col-12">
                        
                        <div class="row bg-black-0 hp-bg-color-dark-100 rounded pe-16 pe-sm-32 mx-0">











                                                       

                            <div class="col ps-16 ps-sm-32 py-24 py-sm-32 overflow-hidden">
                                <div class="row">
                                    <div class="col-12 col-md-8">
                                        
                                        <p class=" mb-0">Configure company details such as name, address, contact information, logo, currency, and otherrs for a personalized and accurate representation of your company in the system.</p>
                                    </div>

                                    <div class="divider border-black-40 hp-border-color-dark-80"></div>

                                    <div class="col-12">
                                        <div class="row align-items-center justify-content-between">
                                            <div class="col-12 col-md-6">
                                                <h3></h3>
                                            </div>

                                            <div class="col-12 col-md-6 hp-profile-action-btn text-end">
                                                <button class="btn btn-ghost btn-primary" data-bs-toggle="modal" data-bs-target="#profileContactEditModal">Edit</button>
                                            </div>
                                            <div style="font-size: 20px; font-weight: 800; margin-bottom: 25px;" class= "col-4 mb-0 fw-medium text-black-100 hp-text-color-dark-0 "> Company Profile</div>

                                            <div class="col-12 hp-profile-content-list mt-8 pb-0 pb-sm-120">
                                                <ul>
                                                    <li>
                                                        <span style="float: left; width: 40%" class="col-4 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Company Name:</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $company_name; ?></span>
                                                    </li>
                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Company Address:</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $company_address; ?></span>
                                                    </li>
                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Company Town</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $company_town; ?></span>
                                                    </li>
                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Company Phone:</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $company_phone; ?></span>
                                                    </li>
                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">State:</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $company_state; ?></span>
                                                    </li>
                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Country:</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $country; ?></span>
                                                    </li>
                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Company Email</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $company_email; ?></span>
                                                    </li>

                                                    <div class="divider border-black-40 hp-border-color-dark-80"></div>
                                                    <div style="font-size: 20px; font-weight: 800 margin-bottom: 25px;" class= "col-4 mb-0 fw-medium text-black-100 hp-text-color-dark-0 "> Bank Informations</div>

                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Bank Name:</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $bank_name; ?></span>
                                                    </li>
                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Account Number</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $account_no; ?></span>
                                                    </li>
                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Account Name:</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $account_name; ?></span>
                                                    </li>                                                    

                                                    <div class="divider border-black-40 hp-border-color-dark-80"></div>
                                                    <div style="font-size: 20px; font-weight: 800 margin-bottom: 25px;" class= "col-4 mb-0 fw-medium text-black-100 hp-text-color-dark-0 "> Other Informations</div>
                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Year's Target:</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $currency; ?> <?php echo number_format($year_target, 2); ?></span>
                                                    </li>
                                                    
                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Currency:</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $invoice_prefix; ?></span>
                                                    </li>
                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Currency:</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $currency; ?></span>
                                                    </li>
                                                    <?php
$vat_status = ($enable_vat === '1') ? 'Enabled' : 'Disabled';
?>
<li class="mt-18">
    <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">
        Enable Vat:
    </span>
    <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50">
        <?php echo $vat_status; ?>
    </span>
</li>

                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Vat Rate:</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $vat_rate; ?></span>
                                                    </li>
                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Invoice Initial Value:</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $initial_value_invoice; ?></span>
                                                    </li>
                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Voucher Initial Value:</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $initial_value_voucher; ?></span>
                                                    </li>
                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Transaction Initial Value:</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $initial_value_transaction; ?></span>
                                                    </li>
                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Theme Color:</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $theme; ?></span>
                                                    </li>
                                                   
                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Company Terms</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><?php echo $terms; ?></span>
                                                    </li>
                                                    <li class="mt-18">
                                                        <span style="float: left; width: 40%" class="col-md-3 mb-0 fw-medium text-black-100 hp-text-color-dark-0">Company Logo</span>
                                                        <span style="float: left; width: 60%" class="col-4 pb-16 fw-medium text-black-80 hp-text-color-dark-50"><img src="../images/<?php echo $company_logo; ?>" width="150px"  width="35px">
                                                    </li>
                                                </ul>
                                                
                                            </div>
                                        </div>
                                    </div>




                                    <div class="divider border-black-40 hp-border-color-dark-80"></div>


                                    <div class="col-12 col-md-8">
                                       
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal fade" id="profileContactEditModal" tabindex="-1" aria-labelledby="profileContactEditModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered" style="max-width: 416px;">
                        <div class="modal-content">
                            <div class="modal-header py-16">
                                <h5 class="modal-title" id="profileContactEditModalLabel">Contact Edit</h5>
                                <button type="button" class="btn-close hp-bg-none d-flex align-items-center justify-content-center" data-bs-dismiss="modal" aria-label="Close">
                                    <i class="ri-close-line hp-text-color-dark-0 lh-1" style="font-size: 24px;"></i>
                                </button>
                            </div>

                            <div class="divider my-0"></div>

                            <div class="modal-body py-48">
                            <form method="post" action="insert-info.php" enctype="multipart/form-data">
                                    <div class="row g-24">
                                        <div class="col-12">
                                            <label class="form-label">Company Name</label>
                                            <input type="text" class="form-control" name="company_name" id="company_name" value="<?php echo $company_name; ?>">
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label">Company Address</label>
                                            <textarea name="company_address" id="company_address" class="form-control"><?php echo $company_address; ?></textarea>
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label">Company Town</label>
                                            <input type="text" class="form-control" name="company_town" id="company_town" value="<?php echo $company_town; ?>">
                                        </div>

                                        <div class="col-12">
                                            <label class="form-label">Company State</label>
                                            <input type="text" class="form-control" name="company_state" id="company_state" value="<?php echo $company_state; ?>">
                                        </div>

                                        <div class="col-12">
                                            <label class="form-label">Company Phone</label>
                                            <input type="text" class="form-control" name="company_phone" id="company_phone" value="<?php echo $company_phone; ?>">
                                        </div>

                                        <div class="col-12">
                                            <label class="form-label">Country</label>
                                            <input name="country" id="country" class="form-control" value="<?php echo $country; ?>">
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label">Company Email</label>
                                            <input type="email" class="form-control" name="company_email" id="company_email" value="<?php echo $company_email; ?>">
                                        </div>                                        

                                        <div class="col-12">
                                            <label class="form-label">Bank Name</label>
                                            <input type="text" class="form-control" name="bank_name" id="bank_name" value="<?php echo $bank_name; ?>">
                                        </div>

                                        <div class="col-12">
                                            <label class="form-label">Account Number</label>
                                            <input type="text" class="form-control" name="account_no" id="account_no" value="<?php echo $account_no; ?>">
                                        </div>

                                        <div class="col-12">
                                            <label class="form-label">Account name</label>
                                            <input type="text" class="form-control" name="account_name" id="account_name" value="<?php echo $account_name; ?>">
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label">Year's Target</label>
                                            <input type="text" class="form-control" name="year_target" id="year_target" value="<?php echo $year_target; ?>">
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label">Invoice Prefix</label>
                                            <input type="text" class="form-control"name="invoice_prefix" id="invoice_prefix" value="<?php echo $invoice_prefix; ?>">
                                        </div>
                                        <div class="col-12">
                                <label class="form-label">Currency</label>
                                <select name="currency" id="currency" class="form-control">
								<option value="₦" <?php if($currency === '₦'){?>selected<?php } ?>>Naira(₦)</option>
								<option value="$" <?php if($currency === '$'){?>selected<?php } ?>>Dollar($)</option>
								<option value="£" <?php if($currency === '£'){?>selected<?php } ?>>Pounds(£)</option>
                                <option value="€" <?php if($currency === '€'){?>selected<?php } ?>>Euro(€)</option>
                                <option value="" <?php if($currency === ''){?>selected<?php } ?>></option>
							</select>
                                        </div>
                                        
                                        <div class="col-12">
                                <label class="form-label">Enable Vat</label>
                                <select name="enable_vat" id="enable_vat" class="form-control">
								<option value="1"<?php if($enable_vat === '1'){?>selected<?php } ?>>Enabled</option>
								<option value="none" <?php if($enable_vat === 'none'){?>selected<?php } ?>>Disabled</option>
							</select>
                                        </div>

                                        <div class="col-12">
                                            <label class="form-label">Vat Rate</label>
                                            <input type="text" class="form-control" name="vat_rate" id="vat_rate" value="<?php echo $vat_rate; ?>">
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label">Invoice Initial Value</label>
                                            <input type="text" class="form-control" name="initial_value_invoice" id="initial_value_invoice" value="<?php echo $initial_value_invoice; ?>">
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label">Voucher Initial Value</label>
                                            <input type="text" class="form-control" name="initial_value_voucher" id="initial_value_voucher" value="<?php echo $initial_value_voucher; ?>">
                                        </div>

                                        <div class="col-12">
                                            <label class="form-label">Transaction Initial Value</label>
                                            <input type="text" class="form-control" name="initial_value_transaction" id="initial_value_transaction" value="<?php echo $initial_value_transaction; ?>">
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label">PDF Theme</label>
                                            <input type="text" class="form-control" name="theme" id="theme" value="<?php echo $theme; ?>">
                                        </div>

                                        <div class="col-12">
                                            <label class="form-label">Company Terms</label>
                                            <textarea name="terms" id="terms" class="form-control"> <?php echo $terms; ?></textarea>
                                        </div>
                                        <div class="col-12">
                                        <label class="form-label">Logo</label>
                                        <input type="file"  name="company_logo" id="company_logo" accept=".png,.jpg,.jpeg" value="<?php echo $company_logo; ?>">
                                        </div>

                                        <div class="col-6">
                                            <button type="submit" value="Send Data" class="btn btn-primary w-100">Edit</button>
                                        </div>

                                        <div class="col-6">
                                            <div class="btn w-100" data-bs-dismiss="modal">Cancel</div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal fade" id="profilePreferanceEditModal" tabindex="-1" aria-labelledby="profilePreferanceEditModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered" style="max-width: 316px;">
                        <div class="modal-content">
                            <div class="modal-header py-16">
                                <h5 class="modal-title" id="profilePreferanceEditModalLabel">Preferance Edit</h5>
                                <button type="button" class="btn-close hp-bg-none d-flex align-items-center justify-content-center" data-bs-dismiss="modal" aria-label="Close">
                                    <i class="ri-close-line hp-text-color-dark-0 lh-1" style="font-size: 24px;"></i>
                                </button>
                            </div>

                            <div class="divider my-0"></div>

                            <div class="modal-body py-48">
                                <form>
                                    <div class="row g-24">
                                        <div class="col-12">
                                            <label for="language" class="form-label">Language</label>
                                            <input type="text" class="form-control" id="language">
                                        </div>

                                        <div class="col-6">
                                            <button type="button" class="btn btn-primary w-100">Edit</button>
                                        </div>

                                        <div class="col-6">
                                            <div class="btn w-100" data-bs-dismiss="modal">Cancel</div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>



    <!-- Plugin -->
    <script data-cfasync="false" src="../../../../../cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
    <script src="../app-assets/js/plugin/jquery.min.js"></script>
    <script src="../app-assets/js/plugin/bootstrap.bundle.min.js"></script>
    <script src="../app-assets/js/plugin/swiper-bundle.min.js"></script>
    <script src="../app-assets/js/plugin/jquery.mask.min.js"></script>
    <script src="../app-assets/js/plugin/autocomplete.min.js"></script>
    <script src="../app-assets/js/plugin/moment.min.js"></script>

    <!-- Layouts -->
    <script src="../app-assets/js/layouts/header-search.js"></script>
    <script src="../app-assets/js/layouts/sider.js"></script>
    <script src="../app-assets/js/components/input-number.js"></script>

    <!-- Base -->
    <script src="../app-assets/js/base/index.js"></script>
    <!-- Customizer -->
    <script src="../app-assets/js/customizer.js"></script>

    <!-- Custom -->
    <script src="../assets/js/main.js"></script>
</body>



</html>